"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppModule = void 0;
const common_1 = require("@nestjs/common");
const config_1 = require("@nestjs/config");
const typeorm_module_1 = require("@nestjs/typeorm/dist/typeorm.module");
const configuration_1 = require("./config/configuration");
const utils_module_1 = require("./utils/utils.module");
const shared_module_1 = require("./shared/shared.module");
const configuration_module_1 = require("./configuration/configuration.module");
const connectors_module_1 = require("./connectors/connectors.module");
const operations_module_1 = require("./operations/operations.module");
const planning_module_1 = require("./planning/planning.module");
const projects_module_1 = require("./projects/projects.module");
const reports_module_1 = require("./reports/reports.module");
const serve_static_1 = require("@nestjs/serve-static");
const path_1 = require("path");
const health_controller_1 = require("./health/health.controller");
const terminus_1 = require("@nestjs/terminus");
let AppModule = class AppModule {
};
exports.AppModule = AppModule;
exports.AppModule = AppModule = __decorate([
    (0, common_1.Module)({
        imports: [
            typeorm_module_1.TypeOrmModule.forRootAsync({
                imports: [config_1.ConfigModule],
                useFactory: (configService) => ({
                    type: 'mysql',
                    host: configService.get('database.host'),
                    port: configService.get('database.port'),
                    username: configService.get('database.username'),
                    password: configService.get('database.password'),
                    database: configService.get('database.database'),
                    entities: [__dirname + '/**/*.entity{.ts,.js}'],
                    autoLoadEntities: true,
                    synchronize: configService.get('database.synchronize'),
                    extra: {
                        connectionLimit: parseInt(process.env.MAX_CONECTION_DB || '5'),
                    },
                }),
                inject: [config_1.ConfigService],
            }),
            config_1.ConfigModule.forRoot({
                load: [configuration_1.default],
                isGlobal: true,
            }),
            utils_module_1.UtilsModule,
            shared_module_1.SharedModule,
            configuration_module_1.ConfigurationModule,
            connectors_module_1.ConnectorsModule,
            operations_module_1.OperationsModule,
            planning_module_1.PlanningModule,
            projects_module_1.ProjectsModule,
            reports_module_1.ReportsModule,
            terminus_1.TerminusModule,
            serve_static_1.ServeStaticModule.forRoot({
                rootPath: (0, path_1.join)(__dirname, '..', 'src/assets'),
                serveRoot: '/assets',
            }),
        ],
        controllers: [health_controller_1.HealthController],
        providers: [
            config_1.ConfigService,
            utils_module_1.UtilsModule,
            shared_module_1.SharedModule,
            configuration_module_1.ConfigurationModule,
            connectors_module_1.ConnectorsModule,
            operations_module_1.OperationsModule,
            planning_module_1.PlanningModule,
            projects_module_1.ProjectsModule,
            reports_module_1.ReportsModule
        ],
    })
], AppModule);
//# sourceMappingURL=app.module.js.map