"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = () => ({
    port: parseInt(process.env.APP_PORT) || 3335,
    hashedPassword: process.env.HASHED_PASSWORD,
    database: {
        type: process.env.DATABASE_TYPE,
        host: process.env.DATABASE_HOST,
        hostReader: process.env.DATABASE_HOST_RO || process.env.DATABASE_HOST,
        port: parseInt(process.env.DATABASE_PORT) || 3306,
        username: process.env.DATABASE_USERNAME,
        password: process.env.DATABASE_PASSWORD,
        database: process.env.DATABASE_DATABASE,
        synchronize: process.env.DATABASE_SYNCHRONIZE
            ? process.env.DATABASE_SYNCHRONIZE === 'true'
            : false,
    },
    aws: {
        region: process.env.AWS_REGION,
        bucket: {
            name: process.env.AWS_BUCKET,
            environment: process.env.AWS_ENVIRONMENT,
        },
        sqs: {
            filesPendingETL: process.env.AWS_SQS_FILES_PENDING_ETL,
        }
    },
    gemini: {
        url: process.env.GEMINI_API_URL,
        apikey: process.env.GEMINI_API_KEY,
    }
});
//# sourceMappingURL=configuration.js.map