import { OriginFlowVariablesService } from './services/origin-flow-variables.service';
import { TagsService } from './services/tags.service';
import { TagEntity } from './entities/tag.entity';
import { CreateTagDto } from './dto/create-tag.dto';
import { CreateTagToLocationDto } from './dto/create-tag-to-location.dto';
export declare class ConfigurationController {
    private readonly originFlowVariablesService;
    private readonly tagsService;
    constructor(originFlowVariablesService: OriginFlowVariablesService, tagsService: TagsService);
    getOriginFlowVariables(): Promise<import("./entities/origin-flow.entity").OriginFlowEntity[]>;
    getOriginFlowVariablesWithRelations(originWorkflowId: string): Promise<{
        id: string;
        name: string;
        validationType: string;
        required: boolean;
        homologation: any;
        options: {
            id: string;
            value: string;
            homologation: any;
        }[];
    }[]>;
    getTagsList(): Promise<import("./dto/tags-list.dto").tagsListDto[]>;
    addTag(body: CreateTagDto): Promise<TagEntity>;
    addTagToLocation(body: CreateTagToLocationDto): Promise<import("./entities/location-tag.entity").LocationTagEntity>;
    removeTagFromLocation({ id }: {
        id: string;
    }): Promise<any>;
}
