"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConfigurationController = void 0;
const common_1 = require("@nestjs/common");
const origin_flow_variables_service_1 = require("./services/origin-flow-variables.service");
const tags_service_1 = require("./services/tags.service");
const create_tag_dto_1 = require("./dto/create-tag.dto");
const create_tag_to_location_dto_1 = require("./dto/create-tag-to-location.dto");
let ConfigurationController = class ConfigurationController {
    constructor(originFlowVariablesService, tagsService) {
        this.originFlowVariablesService = originFlowVariablesService;
        this.tagsService = tagsService;
    }
    async getOriginFlowVariables() {
        return this.originFlowVariablesService.findAll();
    }
    async getOriginFlowVariablesWithRelations(originWorkflowId) {
        const answer = await this.originFlowVariablesService.findAllWithRelationsByOriginFlow(originWorkflowId);
        return answer?.map((item) => {
            return {
                id: item.id,
                name: item.variable.name,
                validationType: item.validationType,
                required: item.required,
                homologation: item.variable.homologations,
                options: item.variable.options.map((option) => {
                    return {
                        id: option.id,
                        value: option.value,
                        homologation: option.homologations,
                    };
                })
            };
        });
    }
    async getTagsList() {
        return this.tagsService.findAll();
    }
    async addTag(body) {
        return this.tagsService.createTag(body);
    }
    async addTagToLocation(body) {
        return this.tagsService.addTagToLocation(body);
    }
    async removeTagFromLocation({ id }) {
        return this.tagsService.removeTagFromLocation(id);
    }
};
exports.ConfigurationController = ConfigurationController;
__decorate([
    (0, common_1.Get)('origin-flow-variables'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], ConfigurationController.prototype, "getOriginFlowVariables", null);
__decorate([
    (0, common_1.Get)('origin-flow-variables-with-relations'),
    __param(0, (0, common_1.Headers)('originFlow')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], ConfigurationController.prototype, "getOriginFlowVariablesWithRelations", null);
__decorate([
    (0, common_1.Get)('get-tags-list'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], ConfigurationController.prototype, "getTagsList", null);
__decorate([
    (0, common_1.Post)('add-or-update-tag'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_tag_dto_1.CreateTagDto]),
    __metadata("design:returntype", Promise)
], ConfigurationController.prototype, "addTag", null);
__decorate([
    (0, common_1.Post)('add-tag-to-location'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_tag_to_location_dto_1.CreateTagToLocationDto]),
    __metadata("design:returntype", Promise)
], ConfigurationController.prototype, "addTagToLocation", null);
__decorate([
    (0, common_1.Delete)('remove-tag-from-location'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], ConfigurationController.prototype, "removeTagFromLocation", null);
exports.ConfigurationController = ConfigurationController = __decorate([
    (0, common_1.Controller)('configuration'),
    __metadata("design:paramtypes", [origin_flow_variables_service_1.OriginFlowVariablesService,
        tags_service_1.TagsService])
], ConfigurationController);
//# sourceMappingURL=configuration.controller.js.map