"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LocationTagEntity = void 0;
const typeorm_1 = require("typeorm");
const tag_entity_1 = require("./tag.entity");
const location_entity_1 = require("../../projects/entities/location.entity");
let LocationTagEntity = class LocationTagEntity {
};
exports.LocationTagEntity = LocationTagEntity;
__decorate([
    (0, typeorm_1.PrimaryGeneratedColumn)('uuid'),
    __metadata("design:type", String)
], LocationTagEntity.prototype, "id", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => location_entity_1.LocationEntity, (location) => location.locationTags, { onDelete: 'CASCADE' }),
    (0, typeorm_1.JoinColumn)({ name: 'location_id' }),
    __metadata("design:type", location_entity_1.LocationEntity)
], LocationTagEntity.prototype, "location", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => tag_entity_1.TagEntity, (tag) => tag.locationTags, { onDelete: 'CASCADE' }),
    (0, typeorm_1.JoinColumn)({ name: 'tag_id' }),
    __metadata("design:type", tag_entity_1.TagEntity)
], LocationTagEntity.prototype, "tag", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'text', nullable: true }),
    __metadata("design:type", String)
], LocationTagEntity.prototype, "comment", void 0);
__decorate([
    (0, typeorm_1.Column)({ name: 'variable_id', type: 'varchar', length: 50, nullable: true }),
    __metadata("design:type", String)
], LocationTagEntity.prototype, "variableId", void 0);
__decorate([
    (0, typeorm_1.Column)({ name: 'variable_name', type: 'varchar', length: 50, nullable: true }),
    __metadata("design:type", String)
], LocationTagEntity.prototype, "variableName", void 0);
__decorate([
    (0, typeorm_1.Column)({ name: 'variable_value', type: 'decimal', precision: 10, scale: 2, nullable: true }),
    __metadata("design:type", Number)
], LocationTagEntity.prototype, "variableValue", void 0);
__decorate([
    (0, typeorm_1.Column)({
        name: 'validation_type',
        type: 'enum',
        enum: ['disabled', 'close_value', 'exact_value', 'over'],
        default: 'disabled',
    }),
    __metadata("design:type", String)
], LocationTagEntity.prototype, "validationType", void 0);
__decorate([
    (0, typeorm_1.Column)({ name: 'validation_threshold', type: 'decimal', precision: 10, scale: 2, nullable: true }),
    __metadata("design:type", Number)
], LocationTagEntity.prototype, "validationThreshold", void 0);
__decorate([
    (0, typeorm_1.Column)({
        name: 'alert_type',
        type: 'enum',
        enum: ['warning', 'flag'],
        default: 'warning',
    }),
    __metadata("design:type", String)
], LocationTagEntity.prototype, "alertType", void 0);
__decorate([
    (0, typeorm_1.Column)({
        name: 'setPoint',
        type: 'enum',
        enum: ['none', 'average', 'up', 'down'],
        default: 'none',
    }),
    __metadata("design:type", String)
], LocationTagEntity.prototype, "setPoint", void 0);
__decorate([
    (0, typeorm_1.Column)({ name: 'reported_by', type: 'varchar', length: 50, nullable: true }),
    __metadata("design:type", String)
], LocationTagEntity.prototype, "reportedBy", void 0);
__decorate([
    (0, typeorm_1.CreateDateColumn)({ name: 'created_at', type: 'timestamp', default: () => 'CURRENT_TIMESTAMP' }),
    __metadata("design:type", Date)
], LocationTagEntity.prototype, "createdAt", void 0);
__decorate([
    (0, typeorm_1.UpdateDateColumn)({
        name: 'updated_at',
        type: 'timestamp',
        default: () => 'CURRENT_TIMESTAMP',
        onUpdate: 'CURRENT_TIMESTAMP',
    }),
    __metadata("design:type", Date)
], LocationTagEntity.prototype, "updatedAt", void 0);
exports.LocationTagEntity = LocationTagEntity = __decorate([
    (0, typeorm_1.Entity)('location_tags')
], LocationTagEntity);
//# sourceMappingURL=location-tag.entity.js.map