"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TagEntity = void 0;
const typeorm_1 = require("typeorm");
const variable_entity_1 = require("./variable.entity");
const location_tag_entity_1 = require("./location-tag.entity");
let TagEntity = class TagEntity {
};
exports.TagEntity = TagEntity;
__decorate([
    (0, typeorm_1.PrimaryGeneratedColumn)('uuid'),
    __metadata("design:type", String)
], TagEntity.prototype, "id", void 0);
__decorate([
    (0, typeorm_1.Column)({ length: 100, unique: true }),
    __metadata("design:type", String)
], TagEntity.prototype, "name", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => variable_entity_1.VariableEntity),
    (0, typeorm_1.JoinColumn)({ name: 'variable_id' }),
    __metadata("design:type", variable_entity_1.VariableEntity)
], TagEntity.prototype, "variable", void 0);
__decorate([
    (0, typeorm_1.Column)({
        type: 'enum',
        name: 'validation_type',
        enum: ['disabled', 'close_value', 'exact_value', 'over'],
        default: 'disabled',
    }),
    __metadata("design:type", String)
], TagEntity.prototype, "validationType", void 0);
__decorate([
    (0, typeorm_1.Column)('decimal', { precision: 10, scale: 2, nullable: true, name: 'validation_threshold' }),
    __metadata("design:type", Number)
], TagEntity.prototype, "validationThreshold", void 0);
__decorate([
    (0, typeorm_1.Column)({
        type: 'enum',
        enum: ['warning', 'flag'],
        default: 'warning',
        name: 'alert_type',
    }),
    __metadata("design:type", String)
], TagEntity.prototype, "alertType", void 0);
__decorate([
    (0, typeorm_1.Column)({
        type: 'enum',
        enum: ['none', 'average', 'up', 'down'],
        default: 'none',
    }),
    __metadata("design:type", String)
], TagEntity.prototype, "setPoint", void 0);
__decorate([
    (0, typeorm_1.Column)('text', { nullable: true }),
    __metadata("design:type", String)
], TagEntity.prototype, "description", void 0);
__decorate([
    (0, typeorm_1.Column)({
        type: 'enum',
        enum: ['disabled', 'enabled'],
        default: 'disabled',
        name: 'use_in_diagnostic',
    }),
    __metadata("design:type", String)
], TagEntity.prototype, "useInDiagnostic", void 0);
__decorate([
    (0, typeorm_1.Column)({ length: 500, default: 'ALL' }),
    __metadata("design:type", String)
], TagEntity.prototype, "originFlowsIds", void 0);
__decorate([
    (0, typeorm_1.CreateDateColumn)({ name: 'created_at', type: 'timestamp', default: () => 'CURRENT_TIMESTAMP' }),
    __metadata("design:type", Date)
], TagEntity.prototype, "createdAt", void 0);
__decorate([
    (0, typeorm_1.UpdateDateColumn)({
        name: 'updated_at',
        type: 'timestamp',
        default: () => 'CURRENT_TIMESTAMP',
        onUpdate: 'CURRENT_TIMESTAMP',
    }),
    __metadata("design:type", Date)
], TagEntity.prototype, "updatedAt", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => location_tag_entity_1.LocationTagEntity, (locationTag) => locationTag.location),
    __metadata("design:type", Array)
], TagEntity.prototype, "locationTags", void 0);
exports.TagEntity = TagEntity = __decorate([
    (0, typeorm_1.Entity)('tags')
], TagEntity);
//# sourceMappingURL=tag.entity.js.map