import { Repository } from 'typeorm';
import { OriginFlowVariableEntity } from '../entities/origin-flow-variable.entity';
import { CreateOriginFlowDto } from '../dto/create-origin-flow.dto';
import { UpdateOriginFlowDto } from '../dto/update-origin-flow.dto';
import { OriginFlowEntity } from '../entities/origin-flow.entity';
import { OriginFlowVariablesDto } from '../dto/originFlowWithVariablesAndOptions.dto';
export declare class OriginFlowVariablesService {
    private readonly originFlowVariableRepository;
    private readonly originFlowEntityRepository;
    constructor(originFlowVariableRepository: Repository<OriginFlowVariableEntity>, originFlowEntityRepository: Repository<OriginFlowEntity>);
    create(createOriginFlowDto: CreateOriginFlowDto): Promise<OriginFlowVariableEntity>;
    findAll(): Promise<OriginFlowEntity[]>;
    getOriginFlowWithVariablesAndOptions(originFlowId: string): Promise<OriginFlowVariablesDto>;
    findAllWithRelationsByOriginFlow(originWorkflowId: string): Promise<OriginFlowVariableEntity[]>;
    getOriginFlowVariablesWithRelations(originWorkflowId: string): Promise<any[]>;
    findOne(id: string): Promise<OriginFlowVariableEntity>;
    update(id: string, updateOriginFlowDto: UpdateOriginFlowDto): Promise<OriginFlowVariableEntity>;
    remove(id: string): Promise<void>;
}
