"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OriginFlowVariablesService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const origin_flow_variable_entity_1 = require("../entities/origin-flow-variable.entity");
const origin_flow_entity_1 = require("../entities/origin-flow.entity");
let OriginFlowVariablesService = class OriginFlowVariablesService {
    constructor(originFlowVariableRepository, originFlowEntityRepository) {
        this.originFlowVariableRepository = originFlowVariableRepository;
        this.originFlowEntityRepository = originFlowEntityRepository;
    }
    async create(createOriginFlowDto) {
        const originFlowVariable = this.originFlowVariableRepository.create(createOriginFlowDto);
        return this.originFlowVariableRepository.save(originFlowVariable);
    }
    async findAll() {
        return this.originFlowEntityRepository.find();
    }
    async getOriginFlowWithVariablesAndOptions(originFlowId) {
        const answer = await this.originFlowEntityRepository.findOne({ where: { id: originFlowId }, relations: ['originFlowVariables', 'originFlowVariables.variable', 'originFlowVariables.variable.options'] });
        const originFlow = await this.originFlowEntityRepository.findOne({ where: { id: originFlowId } });
        const originFlowWithVariablesAndOptions = {
            id: answer.id,
            state: answer.state,
            name: answer.name,
            originFlowVariables: answer.originFlowVariables.map((item) => {
                return {
                    id: item.variable.id,
                    name: item.variable.name,
                    validationType: item.validationType,
                    required: item.required,
                    options: item.variable.options.map((option) => {
                        return {
                            id: option.id,
                            value: option.value,
                        };
                    })
                };
            })
        };
        return {
            originFlowEntity: originFlow,
            originFlowWithVariablesAndOptions,
        };
    }
    async findAllWithRelationsByOriginFlow(originWorkflowId) {
        return this.originFlowVariableRepository.find({ where: { originFlow: { id: originWorkflowId } }, relations: ['variable', 'variable.options'] });
    }
    async getOriginFlowVariablesWithRelations(originWorkflowId) {
        const answer = await this.originFlowVariableRepository.find({ where: { originFlow: { id: originWorkflowId } }, relations: ['variable', 'variable.options'] });
        ;
        return answer?.map((item) => {
            return {
                id: item.variable.id,
                name: item.variable.name,
                validationType: item.validationType,
                required: item.required,
                homologation: item.variable.homologations,
                position: item.position,
                options: item.variable.options.map((option) => {
                    return {
                        id: option.id,
                        value: option.value,
                        homologation: option.homologations,
                    };
                })
            };
        });
    }
    async findOne(id) {
        const originFlowVariable = await this.originFlowVariableRepository.findOne({ where: { id }, relations: ['originFlow', 'variable'] });
        if (!originFlowVariable) {
            throw new common_1.NotFoundException(`OriginFlowVariable with ID ${id} not found`);
        }
        return originFlowVariable;
    }
    async update(id, updateOriginFlowDto) {
        await this.originFlowVariableRepository.update(id, updateOriginFlowDto);
        const updatedOriginFlowVariable = await this.originFlowVariableRepository.findOne({ where: { id }, relations: ['originFlow', 'variable'] });
        if (!updatedOriginFlowVariable) {
            throw new common_1.NotFoundException(`OriginFlowVariable with ID ${id} not found`);
        }
        return updatedOriginFlowVariable;
    }
    async remove(id) {
        const result = await this.originFlowVariableRepository.delete(id);
        if (result.affected === 0) {
            throw new common_1.NotFoundException(`OriginFlowVariable with ID ${id} not found`);
        }
    }
};
exports.OriginFlowVariablesService = OriginFlowVariablesService;
exports.OriginFlowVariablesService = OriginFlowVariablesService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(origin_flow_variable_entity_1.OriginFlowVariableEntity)),
    __param(1, (0, typeorm_1.InjectRepository)(origin_flow_entity_1.OriginFlowEntity)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository])
], OriginFlowVariablesService);
//# sourceMappingURL=origin-flow-variables.service.js.map