import { Repository } from 'typeorm';
import { TagEntity } from '../entities/tag.entity';
import { CreateTagDto } from '../dto/create-tag.dto';
import { tagsListDto } from '../dto/tags-list.dto';
import { LocationTagEntity } from '../entities/location-tag.entity';
import { CreateTagToLocationDto } from '../dto/create-tag-to-location.dto';
export declare class TagsService {
    private readonly tagRepository;
    private readonly locationTagEntity;
    constructor(tagRepository: Repository<TagEntity>, locationTagEntity: Repository<LocationTagEntity>);
    findAll(): Promise<tagsListDto[]>;
    createTag(tagEntity: CreateTagDto): Promise<TagEntity>;
    addTagToLocation({ id, tagId, locationId, comment, value, reportedBy }: CreateTagToLocationDto): Promise<LocationTagEntity>;
    removeTagFromLocation(id: string): Promise<any>;
}
