"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TagsService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const tag_entity_1 = require("../entities/tag.entity");
const location_tag_entity_1 = require("../entities/location-tag.entity");
const variable_entity_1 = require("../entities/variable.entity");
const location_entity_1 = require("../../projects/entities/location.entity");
let TagsService = class TagsService {
    constructor(tagRepository, locationTagEntity) {
        this.tagRepository = tagRepository;
        this.locationTagEntity = locationTagEntity;
    }
    async findAll() {
        const tags = await this.tagRepository.find({ relations: ['variable'] });
        return tags.map((tag) => {
            return {
                id: tag.id,
                name: tag.name,
                description: tag.description,
                variableId: tag.variable?.id,
                variableName: tag.variable?.name,
                validationThreshold: tag.validationThreshold,
                validationType: tag.validationType,
                alertType: tag.alertType,
                setPoint: tag.setPoint,
                useInDiagnostic: tag.useInDiagnostic,
            };
        });
    }
    async createTag(tagEntity) {
        const variable = new variable_entity_1.VariableEntity();
        variable.id = tagEntity.variableId;
        const id = tagEntity.id !== "" ? tagEntity.id : undefined;
        const newTag = {
            id,
            name: tagEntity.name,
            variable,
            validationType: tagEntity.validationType,
            validationThreshold: tagEntity.validationThreshold,
            alertType: tagEntity.alertType,
            setPoint: tagEntity.setPoint,
            description: tagEntity.description,
            useInDiagnostic: tagEntity.useInDiagnostic,
            originFlowsIds: tagEntity.originFlowsIds,
        };
        const newTagCreated = this.tagRepository.save(newTag);
        return newTagCreated;
    }
    async addTagToLocation({ id, tagId, locationId, comment, value, reportedBy }) {
        const tag = await this.tagRepository.findOne({ where: { id: tagId }, relations: ['variable'] });
        if (!tag) {
            throw new common_1.NotFoundException(`Tag with ID ${tagId} not found`);
        }
        const location = new location_entity_1.LocationEntity();
        location.id = locationId;
        const locationTag = new location_tag_entity_1.LocationTagEntity();
        locationTag.id = id !== "" ? id : undefined;
        locationTag.location = location;
        locationTag.tag = tag;
        locationTag.comment = comment;
        locationTag.variableId = tag.variable?.id;
        locationTag.variableName = tag.variable?.name;
        locationTag.variableValue = value;
        locationTag.validationType = tag.validationType;
        locationTag.validationThreshold = tag.validationThreshold;
        locationTag.alertType = tag.alertType;
        locationTag.setPoint = tag.setPoint;
        locationTag.reportedBy = reportedBy;
        return this.locationTagEntity.save(locationTag);
    }
    async removeTagFromLocation(id) {
        await this.locationTagEntity.delete(id);
        return { message: `Tag with ID ${id} removed from location` };
    }
};
exports.TagsService = TagsService;
exports.TagsService = TagsService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(tag_entity_1.TagEntity)),
    __param(1, (0, typeorm_1.InjectRepository)(location_tag_entity_1.LocationTagEntity)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository])
], TagsService);
//# sourceMappingURL=tags.service.js.map