"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.connectorController = void 0;
const common_1 = require("@nestjs/common");
const jwt_auth_guard_1 = require("../shared/auth/jwt-auth.guard");
const chats_service_1 = require("./services/chats.service");
let connectorController = class connectorController {
    constructor(chatsService) {
        this.chatsService = chatsService;
    }
    async updateChat(chat, req) {
        const userId = req.user.userId;
        return this.chatsService.updateChat(chat, userId);
    }
    async deleteChat(chat) {
        return this.chatsService.deleteChat(chat.id);
    }
    async getChatsByActivity(chat) {
        return this.chatsService.getChatsByActivityWithPagination(chat.activityId, chat.page, chat.limit);
    }
    async updateMessage(message, req) {
        const userId = req.user.userId;
        return this.chatsService.updateMessage(message, userId);
    }
};
exports.connectorController = connectorController;
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Post)('updateChat'),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Request)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], connectorController.prototype, "updateChat", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Delete)('deleteChat'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], connectorController.prototype, "deleteChat", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Post)('getChatsByActivity'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], connectorController.prototype, "getChatsByActivity", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Post)('updateMessage'),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Request)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], connectorController.prototype, "updateMessage", null);
exports.connectorController = connectorController = __decorate([
    (0, common_1.Controller)('connector'),
    __metadata("design:paramtypes", [chats_service_1.ChatsService])
], connectorController);
//# sourceMappingURL=connector.controller.js.map