import { DeleteResult, Repository } from 'typeorm';
import { ChatEntity } from '../entities/chat.entity';
import { CreateUpdateChatDto } from '../dto/create-update-chat.dto';
import { CreateUpdateMessageDto } from '../dto/create-update-message.dto';
import { MessageEntity } from '../entities/message.entity';
export declare class ChatsService {
    private readonly chatRepository;
    private readonly MessageRepository;
    constructor(chatRepository: Repository<ChatEntity>, MessageRepository: Repository<MessageEntity>);
    updateChat(createUpdateChatDto: CreateUpdateChatDto, userId: string): Promise<ChatEntity>;
    deleteChat(chatId: string): Promise<DeleteResult>;
    deleteChatByActivity(activityId: string): Promise<DeleteResult>;
    getChatsByActivityWithPagination(activityId: string, page?: number, limit?: number): Promise<ChatEntity[]>;
    updateMessage(chatMessage: CreateUpdateMessageDto, userId: string): Promise<MessageEntity>;
}
