"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChatsService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const chat_entity_1 = require("../entities/chat.entity");
const message_entity_1 = require("../entities/message.entity");
let ChatsService = class ChatsService {
    constructor(chatRepository, MessageRepository) {
        this.chatRepository = chatRepository;
        this.MessageRepository = MessageRepository;
    }
    async updateChat(createUpdateChatDto, userId) {
        const updateData = {
            ...createUpdateChatDto,
            originUser: { id: userId },
        };
        return this.chatRepository.save(updateData);
    }
    async deleteChat(chatId) {
        await this.MessageRepository.delete({ chat: { id: chatId } });
        return await this.chatRepository.delete(chatId);
    }
    async deleteChatByActivity(activityId) {
        await this.MessageRepository.delete({ chat: { activityId } });
        return await this.chatRepository.delete({ activityId });
    }
    async getChatsByActivityWithPagination(activityId, page = 0, limit = 100) {
        const skip = page > 0 ? (page - 1) * limit : page;
        return this.chatRepository.find({
            where: { activityId },
            relations: ['originUser', 'messages'],
            order: { createdAt: 'DESC' },
            skip,
            take: limit,
        });
    }
    async updateMessage(chatMessage, userId) {
        const updateDate = {
            ...chatMessage,
            originUser: { id: userId },
            chat: { id: chatMessage?.chatId },
        };
        return this.MessageRepository.save(updateDate);
    }
};
exports.ChatsService = ChatsService;
exports.ChatsService = ChatsService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(chat_entity_1.ChatEntity)),
    __param(1, (0, typeorm_1.InjectRepository)(message_entity_1.MessageEntity)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository])
], ChatsService);
//# sourceMappingURL=chats.service.js.map