"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@nestjs/core");
const app_module_1 = require("./app.module");
const config_1 = require("@nestjs/config");
const class_validator_1 = require("class-validator");
const express_1 = require("express");
async function bootstrap() {
    const app = await core_1.NestFactory.create(app_module_1.AppModule, {
        bufferLogs: true,
        cors: {
            origin: true,
            preflightContinue: false,
        },
    });
    const configService = app.get(config_1.ConfigService);
    (0, class_validator_1.useContainer)(app.select(app_module_1.AppModule), { fallbackOnErrors: true });
    const globalPrefix = 'api';
    app.setGlobalPrefix(globalPrefix);
    app.enable('trust proxy');
    app.use((0, express_1.json)({ limit: '50mb' }));
    app.use((0, express_1.urlencoded)({ limit: '50mb', extended: true }));
    const port = configService.get('port');
    const maxConnectDb = configService.get('MAX_CONECTION_DB');
    await app.listen(port);
    console.debug(`App running in port ${port}`);
    console.debug(`Max Connection ${maxConnectDb}`);
}
bootstrap();
//# sourceMappingURL=main.js.map