export interface ListOfOptimizationActivitiesDto {
    optimizationActivity: OptimizationActivity[];
    analists: AnalystActivity[];
    requirements: requirementActivities[];
}
export interface AnalystActivity {
    fieldActivityDate: Date;
    id: string;
    optimizationActivityId: string;
    fieldActivityStartTime: string;
    fieldActivityEndTime: string;
    locationId: string;
    locationName: string;
    method: string;
    zone: string;
    pot: number;
    crew: string;
    engineers: string;
    field: string;
    technology: string;
    activityType: string;
    initialActivityState: string;
    finalActivityState: string;
    spm?: number;
    rpm?: number;
    fieldComment: string;
    analysisDate: Date;
    state: string;
    analyzedBy: string;
    executionDate: Date;
    analystUserId: string;
    diagnosis: string;
    recommendation: string;
    statusCandidate: string;
    bottomHoleCondition: string;
    subBottomHoleCondition: number;
    fillageBottomHole: number;
    theoreticalProduction: number;
    theoreticalProductionAfterEfficiency: number;
    pumpEfficiency: number;
    plungerDiameter: number;
    eptAnalysis: number;
    thp: number;
    surfaceUnitBrand: string;
    surfaceUnitModel: string;
    freePolisRod: number;
    strokeLength: number;
    crankHole: number;
    maxLoad: number;
    minLoad: number;
    liquidLevel: number;
    pumpSumergence: number;
    pip: number;
    pwf: number;
    acusticVelocity: number;
    weedsCondition: string;
    fozaCondition: string;
    stuffingBoxStatus: string;
    sonologStatus: string;
    secondaryValve4InchStatus: string;
    sampleValveStatus: string;
    brakesStatus: string;
    selectorStatus: string;
    vfdAccessStatus: string;
    headerAccessStatus: string;
    wellReespaced: string;
    eptBeforeInValue: string;
    eptAfterInValue: string;
    dynoCardTaked: string;
    fluidLevelValue: string;
    pressureTestTaken: string;
    valveTesTaken: string;
    samplesTaken: string;
    mainOptimizationActivity: string;
    mainOptimizationActivitySimulated: boolean;
}
export interface OptimizationActivity {
    id: string;
    optimizationActivityId: string;
    locationId: string;
    locationName: string;
    method: string;
    zone: string;
    pot: number;
    crew: string;
    engineers: string;
    field: string;
    technology: string;
    activityType: string;
    initialActivityState: string;
    finalActivityState: string;
    spm?: number;
    rpm?: number;
    fieldComment: string;
    requiredDate: Date;
    executionDate: Date;
    state: string;
    requesterUserId: string;
    requesterUserName: string;
    variableName: string;
    variableId: string;
    comments: string;
    simulationDate: string;
    productionBefore: number;
    expectedProduction: number;
}
export interface requirementActivities {
    id: string;
    optimizationActivityId: string;
    locationId: string;
    locationName: string;
    method: string;
    zone: string;
    pot: number;
    crew: string;
    engineers: string;
    field: string;
    technology: string;
    activityType: string;
    initialActivityState: string;
    finalActivityState: string;
    fieldComment: string;
    requiredDate: Date;
    executionDate: Date;
    state: string;
    requesterUserId: string;
    requesterUserName: string;
    variableName: string;
    variableId: string;
    comments: string;
    blocker: string[];
}
