"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OptimizationActivityEntity = void 0;
const typeorm_1 = require("typeorm");
const project_entity_1 = require("../../projects/entities/project.entity");
const location_entity_1 = require("../../projects/entities/location.entity");
const field_activity_entity_1 = require("./field-activity.entity");
const planning_activity_entity_1 = require("../../planning/entities/planning-activity.entity");
const user_entity_1 = require("../../shared/entities/user.entity");
const status_enum_1 = require("../dto/status.enum");
let OptimizationActivityEntity = class OptimizationActivityEntity {
};
exports.OptimizationActivityEntity = OptimizationActivityEntity;
__decorate([
    (0, typeorm_1.PrimaryGeneratedColumn)('uuid'),
    __metadata("design:type", String)
], OptimizationActivityEntity.prototype, "id", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => project_entity_1.ProjectEntity),
    (0, typeorm_1.JoinColumn)({ name: 'project_id' }),
    __metadata("design:type", project_entity_1.ProjectEntity)
], OptimizationActivityEntity.prototype, "project", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => location_entity_1.LocationEntity),
    (0, typeorm_1.JoinColumn)({ name: 'location_id' }),
    __metadata("design:type", location_entity_1.LocationEntity)
], OptimizationActivityEntity.prototype, "location", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => field_activity_entity_1.FieldActivityEntity),
    (0, typeorm_1.JoinColumn)({ name: 'origin_activity_id' }),
    __metadata("design:type", field_activity_entity_1.FieldActivityEntity)
], OptimizationActivityEntity.prototype, "originActivity", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => field_activity_entity_1.FieldActivityEntity),
    (0, typeorm_1.JoinColumn)({ name: 'target_activity_id' }),
    __metadata("design:type", field_activity_entity_1.FieldActivityEntity)
], OptimizationActivityEntity.prototype, "targetActivity", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => planning_activity_entity_1.PlanningActivityEntity),
    (0, typeorm_1.JoinColumn)({ name: 'planning_activity' }),
    __metadata("design:type", planning_activity_entity_1.PlanningActivityEntity)
], OptimizationActivityEntity.prototype, "planningActivity", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'date', name: 'executed_at' }),
    __metadata("design:type", Date)
], OptimizationActivityEntity.prototype, "executedDate", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => user_entity_1.UserEntity),
    (0, typeorm_1.JoinColumn)({ name: 'required_user_id' }),
    __metadata("design:type", user_entity_1.UserEntity)
], OptimizationActivityEntity.prototype, "requiredUserId", void 0);
__decorate([
    (0, typeorm_1.Column)({ length: 100 }),
    __metadata("design:type", String)
], OptimizationActivityEntity.prototype, "type", void 0);
__decorate([
    (0, typeorm_1.Column)('json', { nullable: true }),
    __metadata("design:type", Object)
], OptimizationActivityEntity.prototype, "variables", void 0);
__decorate([
    (0, typeorm_1.Column)('json', { nullable: true }),
    __metadata("design:type", Object)
], OptimizationActivityEntity.prototype, "users", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'enum', enum: status_enum_1.StatusEnum, default: 'pending' }),
    __metadata("design:type", String)
], OptimizationActivityEntity.prototype, "status", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'date', name: 'required_at' }),
    __metadata("design:type", Date)
], OptimizationActivityEntity.prototype, "requiredAt", void 0);
__decorate([
    (0, typeorm_1.CreateDateColumn)({ name: 'created_at' }),
    __metadata("design:type", Date)
], OptimizationActivityEntity.prototype, "createdAt", void 0);
__decorate([
    (0, typeorm_1.UpdateDateColumn)({ name: 'updated_at' }),
    __metadata("design:type", Date)
], OptimizationActivityEntity.prototype, "updatedAt", void 0);
exports.OptimizationActivityEntity = OptimizationActivityEntity = __decorate([
    (0, typeorm_1.Entity)('optimization_activities')
], OptimizationActivityEntity);
//# sourceMappingURL=optimization-activity.entity.js.map