"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WaterTestEntity = void 0;
const location_entity_1 = require("../../projects/entities/location.entity");
const typeorm_1 = require("typeorm");
let WaterTestEntity = class WaterTestEntity {
};
exports.WaterTestEntity = WaterTestEntity;
__decorate([
    (0, typeorm_1.PrimaryColumn)(),
    __metadata("design:type", String)
], WaterTestEntity.prototype, "id", void 0);
__decorate([
    (0, typeorm_1.Column)({ name: "sampling_date", type: 'datetime' }),
    __metadata("design:type", Date)
], WaterTestEntity.prototype, "samplingDate", void 0);
__decorate([
    (0, typeorm_1.Column)({ name: "reception_date", type: 'datetime' }),
    __metadata("design:type", Date)
], WaterTestEntity.prototype, "receptionDate", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => location_entity_1.LocationEntity, (location) => location.waterTests, { onDelete: 'CASCADE' }),
    (0, typeorm_1.JoinColumn)({ name: 'location_id' }),
    __metadata("design:type", location_entity_1.LocationEntity)
], WaterTestEntity.prototype, "location", void 0);
__decorate([
    (0, typeorm_1.Column)({ name: "free_water_percentage", type: 'decimal', precision: 5, scale: 2, nullable: true }),
    __metadata("design:type", Number)
], WaterTestEntity.prototype, "freeWaterPercentage", void 0);
__decorate([
    (0, typeorm_1.Column)({ name: "emulsion_percentage", type: 'decimal', precision: 5, scale: 2, nullable: true }),
    __metadata("design:type", Number)
], WaterTestEntity.prototype, "emulsionPercentage", void 0);
__decorate([
    (0, typeorm_1.Column)({ name: "emulsified_water_percentage", type: 'decimal', precision: 5, scale: 2, nullable: true }),
    __metadata("design:type", Number)
], WaterTestEntity.prototype, "emulsifiedWaterPercentage", void 0);
__decorate([
    (0, typeorm_1.Column)({ name: "total_water_percentage", type: 'decimal', precision: 5, scale: 2, nullable: true }),
    __metadata("design:type", Number)
], WaterTestEntity.prototype, "totalWaterPercentage", void 0);
__decorate([
    (0, typeorm_1.Column)({ name: "sediment_percentage", type: 'decimal', precision: 5, scale: 2, nullable: true }),
    __metadata("design:type", Number)
], WaterTestEntity.prototype, "sedimentPercentage", void 0);
__decorate([
    (0, typeorm_1.Column)({ length: 300, nullable: true }),
    __metadata("design:type", String)
], WaterTestEntity.prototype, "observations", void 0);
__decorate([
    (0, typeorm_1.CreateDateColumn)({ name: 'created_at' }),
    __metadata("design:type", Date)
], WaterTestEntity.prototype, "createdAt", void 0);
__decorate([
    (0, typeorm_1.UpdateDateColumn)({ name: 'updated_at' }),
    __metadata("design:type", Date)
], WaterTestEntity.prototype, "updatedAt", void 0);
exports.WaterTestEntity = WaterTestEntity = __decorate([
    (0, typeorm_1.Entity)('water_tests')
], WaterTestEntity);
//# sourceMappingURL=water-test.entity.js.map