import { FieldActivityService } from './services/field-activity.service';
import { CreateFieldActivityDto } from './dto/create-field-activity.dto';
import { OptimizationActivityService } from './services/optimization-activity.service';
import { AddDiagnosticToFieldActivitiesDto } from './dto/add-diagnostic-activities.dto';
import { AddRequirementActivityDto, DeleteRequirementActivityDto, UpdateActivitySatusDto } from './dto/add-requirement-activity.dto';
import { VariableService } from './services/variable.service';
import { DashboardProfileService } from './services/dashboard-profile.service';
import { ConfigurationService } from 'src/shared/services/configuration.service';
import { LocationCategoryChangeService } from './services/ocation-category-change.service';
import { getOptimizationActivitiesDto } from './dto/getOptimization-activities.dto';
export declare class OperationsController {
    private readonly fieldActivityService;
    private readonly optimizationActivityService;
    private readonly variableService;
    private readonly dashboardProfileService;
    private readonly configurationService;
    private readonly locationCategoryChangeService;
    constructor(fieldActivityService: FieldActivityService, optimizationActivityService: OptimizationActivityService, variableService: VariableService, dashboardProfileService: DashboardProfileService, configurationService: ConfigurationService, locationCategoryChangeService: LocationCategoryChangeService);
    addFieldActivity(fieldActivity: CreateFieldActivityDto[], req: any): Promise<any>;
    addOptimizationActivity(optimizationActivity: any, req: any): Promise<any>;
    deleteOptimizationActivity(body: any, req: any): Promise<any>;
    getOptimizationActivityByProjects(body: any, req: any): Promise<any>;
    getOptimizationActivityByLocation(body: any, req: any): Promise<any>;
    addDiagnosticToActivities(body: AddDiagnosticToFieldActivitiesDto, req: any): Promise<any>;
    addRequirementToLocation(body: AddRequirementActivityDto, req: any): Promise<any>;
    deleteRequirementFromLocation(body: DeleteRequirementActivityDto, req: any): Promise<any>;
    changeRequestStatus(body: UpdateActivitySatusDto, req: any): Promise<any>;
    getReuirementById(headers: any): Promise<any>;
    getVariablesList(): Promise<any>;
    updateFieldActivityVariable(body: any): Promise<any>;
    getAllDashboardProfiles(): Promise<any>;
    getAllDashboardProfilesByMethod(method: string): Promise<any>;
    getLocationCategoryChangesById(locationId: string): Promise<any>;
    getListOfOptimizationActivities(body: getOptimizationActivitiesDto): Promise<any>;
}
