"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OperationsController = void 0;
const common_1 = require("@nestjs/common");
const field_activity_service_1 = require("./services/field-activity.service");
const jwt_auth_guard_1 = require("../shared/auth/jwt-auth.guard");
const optimization_activity_service_1 = require("./services/optimization-activity.service");
const add_diagnostic_activities_dto_1 = require("./dto/add-diagnostic-activities.dto");
const add_requirement_activity_dto_1 = require("./dto/add-requirement-activity.dto");
const variable_service_1 = require("./services/variable.service");
const dashboard_profile_service_1 = require("./services/dashboard-profile.service");
const configuration_service_1 = require("../shared/services/configuration.service");
const ocation_category_change_service_1 = require("./services/ocation-category-change.service");
const getOptimization_activities_dto_1 = require("./dto/getOptimization-activities.dto");
let OperationsController = class OperationsController {
    constructor(fieldActivityService, optimizationActivityService, variableService, dashboardProfileService, configurationService, locationCategoryChangeService) {
        this.fieldActivityService = fieldActivityService;
        this.optimizationActivityService = optimizationActivityService;
        this.variableService = variableService;
        this.dashboardProfileService = dashboardProfileService;
        this.configurationService = configurationService;
        this.locationCategoryChangeService = locationCategoryChangeService;
    }
    async addFieldActivity(fieldActivity, req) {
        const userId = req.user.userId;
        return this.fieldActivityService.createFieldActivity(fieldActivity, userId);
    }
    async addOptimizationActivity(optimizationActivity, req) {
        const userId = req.user.userId;
        return this.optimizationActivityService.updateActivity(optimizationActivity, userId);
    }
    async deleteOptimizationActivity(body, req) {
        return this.optimizationActivityService.deleteActivity(body.activityId);
    }
    async getOptimizationActivityByProjects(body, req) {
        return this.optimizationActivityService.getOptimizationActivityByProject(body.projectId, body.start, body.end, body.status);
    }
    async getOptimizationActivityByLocation(body, req) {
        return this.optimizationActivityService.getOptimizationActivityByLocation(body.locationIds, body.start, body.end, body.status);
    }
    async addDiagnosticToActivities(body, req) {
        return this.optimizationActivityService.addDiagnosticToFieldActivities(body);
    }
    async addRequirementToLocation(body, req) {
        return this.optimizationActivityService.addRequirementToLocation(body);
    }
    async deleteRequirementFromLocation(body, req) {
        return this.optimizationActivityService.deleteRequirementFromLocation(body);
    }
    async changeRequestStatus(body, req) {
        return this.optimizationActivityService.updateOptimizationActivityStatus(body);
    }
    async getReuirementById(headers) {
        const requirementId = headers['requirementid'];
        return this.optimizationActivityService.getRequirementById(requirementId);
    }
    async getVariablesList() {
        const variables = await this.configurationService.findByCode('ALLOW_WELL_VARIABLES');
        return variables?.jsonConfig || [];
    }
    async updateFieldActivityVariable(body) {
        return this.fieldActivityService.updateFieldActivityVariable(body);
    }
    async getAllDashboardProfiles() {
        return this.dashboardProfileService.getAllDashboardProfiles();
    }
    async getAllDashboardProfilesByMethod(method) {
        return this.dashboardProfileService.getAllDashboardProfilesByMethod(method);
    }
    async getLocationCategoryChangesById(locationId) {
        return this.locationCategoryChangeService.getCategoryChangesByLocation(locationId);
    }
    async getListOfOptimizationActivities(body) {
        return this.optimizationActivityService.getPendingOptimizationActivities(body);
    }
};
exports.OperationsController = OperationsController;
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Post)('addFieldActivity'),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Request)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Array, Object]),
    __metadata("design:returntype", Promise)
], OperationsController.prototype, "addFieldActivity", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Post)('addOptimizationActivity'),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Request)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], OperationsController.prototype, "addOptimizationActivity", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Delete)('deleteOptimizationActivity'),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Request)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], OperationsController.prototype, "deleteOptimizationActivity", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Post)('getOptimizationActivityByProject'),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Request)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], OperationsController.prototype, "getOptimizationActivityByProjects", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Post)('getOptimizationActivityByLocation'),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Request)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], OperationsController.prototype, "getOptimizationActivityByLocation", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Post)('addDiagnosticActivities'),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Request)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [add_diagnostic_activities_dto_1.AddDiagnosticToFieldActivitiesDto, Object]),
    __metadata("design:returntype", Promise)
], OperationsController.prototype, "addDiagnosticToActivities", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Post)('addRequirementToLocation'),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Request)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [add_requirement_activity_dto_1.AddRequirementActivityDto, Object]),
    __metadata("design:returntype", Promise)
], OperationsController.prototype, "addRequirementToLocation", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Delete)('deleteRequirementFromLocation'),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Request)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [add_requirement_activity_dto_1.DeleteRequirementActivityDto, Object]),
    __metadata("design:returntype", Promise)
], OperationsController.prototype, "deleteRequirementFromLocation", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Post)('updateOptimizationActivityStatus'),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Request)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [add_requirement_activity_dto_1.UpdateActivitySatusDto, Object]),
    __metadata("design:returntype", Promise)
], OperationsController.prototype, "changeRequestStatus", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Get)('getReuirementById'),
    __param(0, (0, common_1.Headers)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], OperationsController.prototype, "getReuirementById", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Get)('getVariablesList'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], OperationsController.prototype, "getVariablesList", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Post)('updateFieldActivityVariable'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], OperationsController.prototype, "updateFieldActivityVariable", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Get)('getAllDashboardProfiles'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], OperationsController.prototype, "getAllDashboardProfiles", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Get)('getAllDashboardProfilesByMethod'),
    __param(0, (0, common_1.Headers)('method')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], OperationsController.prototype, "getAllDashboardProfilesByMethod", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Get)('getLocationCategoryChangesById'),
    __param(0, (0, common_1.Headers)('locationid')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], OperationsController.prototype, "getLocationCategoryChangesById", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Post)('getListOfOptimizationActivities'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [getOptimization_activities_dto_1.getOptimizationActivitiesDto]),
    __metadata("design:returntype", Promise)
], OperationsController.prototype, "getListOfOptimizationActivities", null);
exports.OperationsController = OperationsController = __decorate([
    (0, common_1.Controller)('operations'),
    __metadata("design:paramtypes", [field_activity_service_1.FieldActivityService,
        optimization_activity_service_1.OptimizationActivityService,
        variable_service_1.VariableService,
        dashboard_profile_service_1.DashboardProfileService,
        configuration_service_1.ConfigurationService,
        ocation_category_change_service_1.LocationCategoryChangeService])
], OperationsController);
//# sourceMappingURL=operation.controller.js.map