import { Repository } from 'typeorm';
import { FieldActivityEntity } from '../entities/field-activity.entity';
import { VariableService } from './variable.service';
import { CreateFieldActivityDto } from '../dto/create-field-activity.dto';
import { ProjectsService } from '../../projects/services/projects.service';
import { TaskService } from '../../shared/services/tasks.service';
import { OriginFlowVariablesService } from '../../configuration/services/origin-flow-variables.service';
import { UserService } from '../../shared/services/users.service';
import { LocationsService } from '../../projects/services/locations.service';
export declare class FieldActivityService {
    private readonly fieldActivityRepository;
    private readonly VariableService;
    private readonly projectsService;
    private readonly taskService;
    private readonly userService;
    private readonly originFlowVariablesService;
    private readonly locationsService;
    constructor(fieldActivityRepository: Repository<FieldActivityEntity>, VariableService: VariableService, projectsService: ProjectsService, taskService: TaskService, userService: UserService, originFlowVariablesService: OriginFlowVariablesService, locationsService: LocationsService);
    createFieldActivity(fieldActivity: CreateFieldActivityDto[], userId: string): Promise<any>;
    getActivitiesForReport(projectId: string, startDate: Date, endDate: Date, originFlowId: string[], variableIds: string[]): Promise<FieldActivityEntity[]>;
    updateActivityStatus(id: string, status: string): Promise<FieldActivityEntity>;
    updateFieldActivityVariable(body: any): Promise<any>;
    getActivitiesForAnalyst(projectId: string, startDate: Date, endDate: Date): Promise<any[]>;
}
