"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FieldActivityService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const field_activity_entity_1 = require("../entities/field-activity.entity");
const variable_service_1 = require("./variable.service");
const projects_service_1 = require("../../projects/services/projects.service");
const tasks_service_1 = require("../../shared/services/tasks.service");
const create_task_dto_1 = require("../../shared/dto/create-task.dto");
const origin_flow_variables_service_1 = require("../../configuration/services/origin-flow-variables.service");
const users_service_1 = require("../../shared/services/users.service");
const locations_service_1 = require("../../projects/services/locations.service");
const originFlowWithVariablesAndOptions_dto_1 = require("../../configuration/dto/originFlowWithVariablesAndOptions.dto");
const functions_1 = require("../../utils/functions/functions");
let FieldActivityService = class FieldActivityService {
    constructor(fieldActivityRepository, VariableService, projectsService, taskService, userService, originFlowVariablesService, locationsService) {
        this.fieldActivityRepository = fieldActivityRepository;
        this.VariableService = VariableService;
        this.projectsService = projectsService;
        this.taskService = taskService;
        this.userService = userService;
        this.originFlowVariablesService = originFlowVariablesService;
        this.locationsService = locationsService;
    }
    async createFieldActivity(fieldActivity, userId) {
        const errors = [];
        const startTime = Date.now();
        console.log(`${new Date(startTime).toLocaleString()} - Starting field activity upload...`);
        try {
            const project = await this.projectsService.findOne(fieldActivity[0].projectId);
            const addError = ({ field, message, type }) => {
                const checkIfExist = errors.find((x) => x.message === message);
                if (!checkIfExist) {
                    errors.push({ field, message: message, type });
                }
            };
            if (!project) {
                addError({
                    field: 'project',
                    message: `Project with ID ${fieldActivity[0].projectId} not found`,
                    type: 'error'
                });
                return errors;
            }
            const AllLocations = await this.locationsService.findAll();
            const { originFlowEntity, originFlowWithVariablesAndOptions: originFlow } = await this.originFlowVariablesService.getOriginFlowWithVariablesAndOptions(fieldActivity[0].originFlowId);
            const getAllUsers = await this.userService.getAllUsers();
            if (!originFlow) {
                addError({
                    field: 'originFlow',
                    message: `Origin Flow with ID ${fieldActivity[0].originFlowId} not found`,
                    type: 'error'
                });
                return errors;
            }
            const task = await this.taskService.create({
                name: create_task_dto_1.TaskType.upload_field_activity,
                userId,
                originFlow: originFlowEntity,
            });
            await this.fieldActivityRepository.manager.transaction(async (transactionalEntityManager) => {
                const validatedActivities = [];
                for (const activity of fieldActivity) {
                    const location = AllLocations.find(location => location.id === activity.locationId);
                    if (!location) {
                        addError({
                            field: 'location',
                            message: `Location with ID ${activity.locationId} not found`,
                            type: 'error'
                        });
                        continue;
                    }
                    let executedDate = new Date(activity.executedDate);
                    if (executedDate) {
                        executedDate = executedDate.toISOString()?.split('T')[0];
                    }
                    const existingActivity = await transactionalEntityManager.findOne(field_activity_entity_1.FieldActivityEntity, { where: { fieldId: activity.fieldId, executedDate } });
                    const activityToSave = {
                        id: existingActivity?.id,
                        project: project,
                        location: location,
                        fieldId: activity.fieldId,
                        task: task,
                        type: originFlow?.name,
                        users: [],
                        variables: [],
                        status: 'pending',
                        createdAt: undefined,
                        updatedAt: undefined,
                        executedDate,
                        originFlow: originFlowEntity,
                        groupAssigned: activity?.groupAssigned,
                    };
                    activity.users.forEach(user => {
                        const userFound = getAllUsers.find(u => u.id === user.id);
                        if (!userFound) {
                            addError({
                                field: 'user',
                                message: `User with ID ${user.id} / ${user.name} not found`,
                                type: 'warning'
                            });
                            activityToSave.users.push({ ...user, alert: 'User not found' });
                        }
                        else {
                            activityToSave.users.push(user);
                        }
                    });
                    for (const variable of activity.variables) {
                        const variableValidation = originFlow.originFlowVariables.find(v => v.id === variable.id || v.name === variable.name);
                        if (!variableValidation) {
                            addError({
                                field: 'variable',
                                message: `Variable ${variable.name} no encontrada en la lista de variables`,
                                type: variableValidation?.required ? 'error' : 'warning'
                            });
                            continue;
                        }
                        if (variableValidation?.validationType === originFlowWithVariablesAndOptions_dto_1.validationTypeEnum.boolean) {
                            if (variable.value !== 'true' && variable.value !== 'false') {
                                addError({
                                    field: 'variable',
                                    message: `Variable ${variable.name} debe ser un valor TRUE o FALSE`,
                                    type: variableValidation?.required ? 'error' : 'warning'
                                });
                                continue;
                            }
                        }
                        else if (variableValidation?.validationType === originFlowWithVariablesAndOptions_dto_1.validationTypeEnum.number) {
                            if (isNaN(Number(variable.value))) {
                                if (variable.value.toLowerCase() === "s/i") {
                                    continue;
                                }
                                const isFraction = (0, functions_1.validateAndConvertFraction)(variable.value);
                                if (!isFraction) {
                                    addError({
                                        field: 'variable',
                                        message: `Variable ${variable.name} debe ser un numero`,
                                        type: variableValidation?.required ? 'error' : 'warning'
                                    });
                                    continue;
                                }
                            }
                        }
                        else if (variableValidation?.validationType === originFlowWithVariablesAndOptions_dto_1.validationTypeEnum.date) {
                            if (isNaN(Date.parse(variable.value))) {
                                addError({
                                    field: 'variable',
                                    message: `Variable ${variable.name} debe ser una fecha valida`,
                                    type: variableValidation?.required ? 'error' : 'warning'
                                });
                                continue;
                            }
                        }
                        else if (variableValidation?.validationType === originFlowWithVariablesAndOptions_dto_1.validationTypeEnum.list) {
                            const option = variableValidation.options.find(option => option.value === variable.value);
                            if (!option) {
                                addError({
                                    field: 'variable',
                                    message: `Variable ${variable.name} debe tener un valor de : ${variableValidation.options.length > 10 ? variableValidation.options.splice(0, 10).map(option => option.value).join(', ') : variableValidation.options.map(option => option.value).join(', ')}`,
                                    type: variableValidation?.required ? 'error' : 'warning'
                                });
                                continue;
                            }
                        }
                        else {
                            if (!variable.value || variable.value === '') {
                                addError({
                                    field: 'variable',
                                    message: `Variable ${variable.name} debe tener un valor valido`,
                                    type: variableValidation?.required ? 'error' : 'warning'
                                });
                                continue;
                            }
                        }
                        activityToSave.variables.push({
                            id: variableValidation?.id,
                            variable: variableValidation?.name,
                            value: variable.value,
                            type: variableValidation?.validationType
                        });
                    }
                    const requiredVariables = originFlow.originFlowVariables.filter(variable => variable.required);
                    const tipoActividad = activityToSave.variables.find(variable => variable.id === 'ae5f1c52-da3c-4b0d-80c8-abf6913a966d');
                    for (const requiredVar of requiredVariables) {
                        if (!activityToSave.variables.find(variable => variable.id === requiredVar.id) && tipoActividad?.value !== 'Revisión') {
                            addError({
                                field: 'variable',
                                message: `Variable with ID ${requiredVar.name} is required`,
                                type: 'error'
                            });
                        }
                    }
                    validatedActivities.push(activityToSave);
                }
                for (const activity of validatedActivities) {
                    if (typeof activity?.groupAssigned !== 'string' || activity?.groupAssigned === 'undefined' || activity?.groupAssigned === 'null') {
                        const cuadrilla = activity.variables.find(variable => variable.id === '290aa7b7-299e-48e6-bcae-ad9e083c5cac');
                        activity.groupAssigned = `cuadrilla-${cuadrilla?.value}`;
                    }
                    await transactionalEntityManager.save(field_activity_entity_1.FieldActivityEntity, activity);
                }
            });
            await this.taskService.update(task.id, { errors: errors.length > 0 ? errors : undefined, state: "started" });
            const endTime = Date.now();
            const executionTime = endTime - startTime;
            if (executionTime > 5000) {
                console.warn(`Execution time exceeded 5 seconds: ${executionTime}ms`);
            }
            else {
                console.log(`Execution time: ${executionTime}ms`);
            }
            console.log(`${new Date(endTime).toLocaleString()} - Starting field activity upload...`);
            return {
                message: 'Field Activity uploaded',
                task: task,
                errors
            };
        }
        catch (error) {
            return new common_1.HttpException({ errors }, common_1.HttpStatus.BAD_REQUEST);
        }
    }
    async getActivitiesForReport(projectId, startDate, endDate, originFlowId, variableIds) {
        const queryBuilder = this.fieldActivityRepository.createQueryBuilder('fieldActivity')
            .leftJoinAndSelect('fieldActivity.location', 'location')
            .leftJoinAndSelect('fieldActivity.project', 'project')
            .leftJoinAndSelect('fieldActivity.originFlow', 'originFlow')
            .where('DATE(fieldActivity.executed_at) >= :start', { start: `${startDate}` })
            .andWhere('DATE(fieldActivity.executed_at) <= :end', { end: `${endDate}` })
            .andWhere('fieldActivity.origin_flow_id IN (:...originFlowId)', { originFlowId });
        if (projectId) {
            queryBuilder.andWhere('fieldActivity.project_id = :projectId', { projectId });
        }
        if (variableIds && variableIds.length > 0) {
            variableIds.forEach((variableId, index) => {
                queryBuilder.andWhere(`JSON_SEARCH(fieldActivity.variables, 'one', :variableId${index}) IS NOT NULL`, { [`variableId${index}`]: variableId });
            });
        }
        const [query, parameters] = queryBuilder.getQueryAndParameters();
        console.log('Query Parameters:', parameters);
        const queryResult = await queryBuilder.getMany();
        console.debug('Query Result:', queryResult.length);
        return queryBuilder.getMany();
    }
    async updateActivityStatus(id, status) {
        const fieldActivity = await this.fieldActivityRepository.findOne({ where: { id } });
        if (!fieldActivity) {
            return;
        }
        fieldActivity.status = status;
        return this.fieldActivityRepository.save(fieldActivity);
    }
    async updateFieldActivityVariable(body) {
        try {
            const errors = [];
            const variablesEnableToEdit = [
                { field: "liquidLevel", variableId: "e16b12b8-caa4-11ef-837b-f62cf753b79c", variableName: "Prof Nivel", type: "number" },
                { field: "pumpSumergence", variableId: "dc047f53-c916-4840-80a0-27e7a930e378", variableName: "Sumergencia", type: "number" },
                { field: "pip", variableId: "d4a0835c-a4c3-4da6-af69-a6ffa4bf5456", variableName: "PIP", type: "number" },
                { field: "pwf", variableId: "9d15ecbd-6aef-42c4-86c5-463c2e2444b5", variableName: "Pwf", type: "number" },
                { field: "spm", variableId: "bc32f3f7-980e-4681-aa38-bfae46bbb715", variableName: "SPM", type: "number" },
                { field: "structuralMaxLoad", variableId: "94996b01-1241-11f0-bbc3-00505652cca1", variableName: "structural_max_load", type: "number" },
                { field: "currentPercentageMaxLoad", variableId: "ab2534f7-1241-11f0-bbc3-00505652cca1", variableName: "current_percetange_structural_load", type: "number" },
                { field: "surfaceUnitBrand", variableId: "888e49bb-093d-491a-9369-47fbb487678f", variableName: "Marca Balancin", type: "number" },
                { field: "surfaceUnitModel", variableId: "54add674-1701-414b-a4f9-2021ff91fc15", variableName: "Modelo Balancin", type: "number" },
            ];
            const fieldActivity = await this.fieldActivityRepository.findOne({ where: { id: body.originFieldActivityIds } });
            if (!fieldActivity) {
                errors.push({ message: `No se encontró actividad de campo con el ID ${body.originFieldActivityIds} para editar` });
                throw new common_1.HttpException({
                    message: `No se encontró actividad de campo con el ID ${body.originFieldActivityIds} para editar`,
                }, common_1.HttpStatus.BAD_REQUEST);
            }
            const fieldActivityVariables = fieldActivity?.variables;
            const ommit = ['originFieldActivityIds'];
            const variablesToedit = Object.keys(body)?.filter(v => !ommit.includes(v));
            for (const variableToEdit of variablesToedit) {
                const isEnableToEdit = variablesEnableToEdit.find(v => v.field === variableToEdit);
                if (!isEnableToEdit) {
                    errors.push({ message: `No se puede editar la variable ${variableToEdit} en la actividad de campo` });
                    continue;
                }
                const exist = fieldActivityVariables.findIndex(v => v.id === isEnableToEdit.variableId);
                if (exist === -1) {
                    fieldActivity.variables.push({
                        id: isEnableToEdit.variableId,
                        variable: isEnableToEdit.variableName,
                        value: body[variableToEdit],
                        type: isEnableToEdit.type
                    });
                }
                else {
                    fieldActivity.variables[exist].value = body[variableToEdit];
                }
            }
            await this.fieldActivityRepository.save(fieldActivity);
            return {
                status: errors.length > 0 ? 'partial' : 'success',
                errors
            };
        }
        catch (error) {
            throw new common_1.HttpException({
                message: 'An error occurred while updating the field activity variable',
                details: error.message,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async getActivitiesForAnalyst(projectId, startDate, endDate) {
        const parsedStartDate = typeof startDate === 'string' ? new Date(startDate) : startDate;
        const firstDayOfMonth = new Date(parsedStartDate.getFullYear(), parsedStartDate.getMonth(), 1);
        const firstDayOfMonthString = firstDayOfMonth.toISOString().split('T')[0];
        const parsedEndDate = typeof endDate === 'string' ? new Date(endDate) : endDate;
        const lastDayOfMonth = new Date(parsedEndDate.getFullYear(), parsedEndDate.getMonth() + 1, 0);
        const lastDayOfMonthString = lastDayOfMonth.toISOString().split('T')[0];
        const queryBuilder = this.fieldActivityRepository.createQueryBuilder('fieldActivity')
            .leftJoinAndSelect('fieldActivity.location', 'location')
            .leftJoinAndSelect('fieldActivity.project', 'project')
            .leftJoinAndSelect('fieldActivity.originFlow', 'originFlow')
            .where('DATE(fieldActivity.executed_at) >= :start', { start: `${firstDayOfMonthString}` })
            .andWhere('DATE(fieldActivity.executed_at) <= :end', { end: `${lastDayOfMonthString}` });
        if (projectId) {
            queryBuilder.andWhere('fieldActivity.project_id = :projectId', { projectId });
        }
        const activities = await queryBuilder.getMany();
        const activitiesShouldBeAnalyzed = [];
        for (const act of activities) {
            const nivel = act.variables.find(v => v.id === '1e4ebb51-5155-4a64-8d20-892285251e21')?.value;
            const carta = act.variables.find(v => v.id === '90d6d4db-d8e2-436d-9385-4ffad7e80aa2')?.value;
            if (nivel === 'true' || carta === 'true') {
                activitiesShouldBeAnalyzed.push(act);
            }
        }
        return activitiesShouldBeAnalyzed;
    }
};
exports.FieldActivityService = FieldActivityService;
exports.FieldActivityService = FieldActivityService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(field_activity_entity_1.FieldActivityEntity)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        variable_service_1.VariableService,
        projects_service_1.ProjectsService,
        tasks_service_1.TaskService,
        users_service_1.UserService,
        origin_flow_variables_service_1.OriginFlowVariablesService,
        locations_service_1.LocationsService])
], FieldActivityService);
//# sourceMappingURL=field-activity.service.js.map