import { DeleteResult, Repository } from 'typeorm';
import { OptimizationActivityEntity } from '../entities/optimization-activity.entity';
import { UpdateOptimizationActivityDto } from '../dto/update-optimization-activity.dto';
import { StatusEnum } from '../dto/status.enum';
import { AddDiagnosticToFieldActivitiesDto } from '../dto/add-diagnostic-activities.dto';
import { AddRequirementActivityDto, DeleteRequirementActivityDto, UpdateActivitySatusDto } from '../dto/add-requirement-activity.dto';
import { ActivityMessageEntity } from '../entities/activity-message.entity';
import { RequirmentDto } from '../dto/getRequirment.dto';
import { FieldActivityService } from './field-activity.service';
import { GetReportWithDataDto } from 'src/reports/dto/get-report-with-data.dto';
import { ListOfOptimizationActivitiesDto } from '../dto/listOfOptimizationActivities.dto';
import { getOptimizationActivitiesDto } from '../dto/getOptimization-activities.dto';
export declare class OptimizationActivityService {
    private readonly optimizationActivityRepository;
    private readonly activityMessageRepository;
    private readonly fieldActivityService;
    constructor(optimizationActivityRepository: Repository<OptimizationActivityEntity>, activityMessageRepository: Repository<ActivityMessageEntity>, fieldActivityService: FieldActivityService);
    updateActivity(updateOptimizationActivityDto: UpdateOptimizationActivityDto, userId: string): Promise<OptimizationActivityEntity>;
    deleteActivity(taskId: string): Promise<DeleteResult>;
    getOptimizationActivityByProject(projectId: string, startDate: Date, endDate: Date, status: string): Promise<OptimizationActivityEntity[]>;
    getOptimizationActivityByLocation(locationIds: string[], startDate: Date, endDate: Date, status: string): Promise<OptimizationActivityEntity[]>;
    addDiagnosticToFieldActivities(addDiagnosticActivitiesDto: AddDiagnosticToFieldActivitiesDto): Promise<OptimizationActivityEntity[]>;
    addRequirementToLocation(addRequirementActivityDto: AddRequirementActivityDto): Promise<OptimizationActivityEntity>;
    updateOptimizationActivityStatus(updateActivitySatusDto: UpdateActivitySatusDto): Promise<OptimizationActivityEntity>;
    getRequirementById(requirementId: string): Promise<RequirmentDto>;
    deleteRequirementFromLocation(body: DeleteRequirementActivityDto): Promise<any>;
    removeOptimizationRequirementWhenDeletePlanningActivity(planningActivityId: string): Promise<any>;
    getAnalyzedActivities({ startDate, endDate, projectId }: GetReportWithDataDto): Promise<OptimizationActivityEntity[]>;
    getActivesRequirements({ startDate, endDate, projectId }: GetReportWithDataDto): Promise<any>;
    updateActivityStatusById(ids: string[], status: StatusEnum): Promise<OptimizationActivityEntity[]>;
    getPendingOptimizationActivities(body: getOptimizationActivitiesDto): Promise<ListOfOptimizationActivitiesDto>;
}
