"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OptimizationActivityService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const optimization_activity_entity_1 = require("../entities/optimization-activity.entity");
const status_enum_1 = require("../dto/status.enum");
const activity_message_entity_1 = require("../entities/activity-message.entity");
const field_activity_service_1 = require("./field-activity.service");
const optimization_activities_type_enum_1 = require("../Enum/optimization-activities-type.enum");
let OptimizationActivityService = class OptimizationActivityService {
    constructor(optimizationActivityRepository, activityMessageRepository, fieldActivityService) {
        this.optimizationActivityRepository = optimizationActivityRepository;
        this.activityMessageRepository = activityMessageRepository;
        this.fieldActivityService = fieldActivityService;
    }
    async updateActivity(updateOptimizationActivityDto, userId) {
        const updateData = {
            ...updateOptimizationActivityDto,
            project: { id: updateOptimizationActivityDto.projectId },
            location: { id: updateOptimizationActivityDto.locationId },
            originActivity: { id: updateOptimizationActivityDto.originActivityId },
            targetActivity: { id: updateOptimizationActivityDto.targetActivityId },
            planningActivity: { id: updateOptimizationActivityDto.planningActivity },
            requiredUserId: { id: userId },
        };
        return this.optimizationActivityRepository.save(updateData);
    }
    async deleteActivity(taskId) {
        return this.optimizationActivityRepository.delete(taskId);
    }
    async getOptimizationActivityByProject(projectId, startDate, endDate, status) {
        const queryBuilder = this.optimizationActivityRepository.createQueryBuilder('optimizationActivity')
            .leftJoinAndSelect('optimizationActivity.project', 'project')
            .leftJoinAndSelect('optimizationActivity.location', 'location')
            .leftJoinAndSelect('optimizationActivity.requiredUserId', 'requiredUserId')
            .where('optimizationActivity.project = :projectId', { projectId });
        if (startDate && endDate) {
            queryBuilder.andWhere('DATE(optimizationActivity.required_at) >= :startDate', { startDate });
            queryBuilder.andWhere('DATE(optimizationActivity.required_at) <= :endDate', { endDate });
        }
        if (status) {
            queryBuilder.andWhere('optimizationActivity.status = :status', { status });
        }
        return queryBuilder.getMany();
    }
    async getOptimizationActivityByLocation(locationIds, startDate, endDate, status) {
        const queryBuilder = this.optimizationActivityRepository.createQueryBuilder('optimizationActivity')
            .leftJoinAndSelect('optimizationActivity.project', 'project')
            .leftJoinAndSelect('optimizationActivity.location', 'location')
            .leftJoinAndSelect('optimizationActivity.requiredUserId', 'requiredUserId')
            .where('optimizationActivity.location IN (:...locationIds)', { locationIds });
        if (startDate && endDate) {
            queryBuilder.andWhere('DATE(optimizationActivity.required_at) >= :startDate', { startDate });
            queryBuilder.andWhere('DATE(optimizationActivity.required_at) <= :endDate', { endDate });
        }
        if (status) {
            queryBuilder.andWhere('optimizationActivity.status = :status', { status });
        }
        return queryBuilder.getMany();
    }
    async addDiagnosticToFieldActivities(addDiagnosticActivitiesDto) {
        const diagnosticVariables = [
            { 'id': "26fd1c80-ec8d-11ef-95e3-00505652cca1", "name": "Diagnostico", "field": "diagnostic", "type": "Diagnostic" },
            { 'id': "26fd1ece-ec8d-11ef-95e3-00505652cca1", "name": "Recomendacion", "field": "recommendation", "type": "Diagnostic" },
            { 'id': "26fd1f13-ec8d-11ef-95e3-00505652cca1", "name": "Status Candidato", "field": "candidateSate", "type": "Diagnostic" },
            { 'id': '26fd1f4d-ec8d-11ef-95e3-00505652cca1', "name": "Condicion de Fondo", "field": "bottomHoleCondition", "type": "Diagnostic" },
            { 'id': '26fd1f8a-ec8d-11ef-95e3-00505652cca1', "name": "Llenado del Equipo de Fondo", "field": "bottomHoleFillage", "type": "Diagnostic" },
            { 'id': '26fd1fc0-ec8d-11ef-95e3-00505652cca1', "name": "Comentario del Estado del Equipo de Fondo", "field": "bottomHopoleConditionComments", "type": "Diagnostic" },
            { 'id': '3e545921-fc61-11ef-a39b-00505652cca1', "name": "Sub Condicion de Fondo", "field": "subBottomHoleCondition", "type": "Diagnostic" },
            { 'id': '3e545b5c-fc61-11ef-a39b-00505652cca1', "name": "Produccion Teorica", "field": "theoricalProduction", "type": "Diagnostic" },
            { 'id': '1a6387e8-05db-11f0-af91-00505652cca1', "name": "Produccion Teorica Post Eficiencia", "field": "adjustProduction", "type": "Diagnostic" },
            { 'id': '81047dd8-05d4-11f0-af91-00505652cca1', "name": "pump efficiency", "field": "pumpEfficiency", "type": "Diagnostic" },
            { 'id': 'e47fc3c4-fc6f-11ef-a39b-00505652cca1', "name": "Diametro Piston", "field": "dplunger", "type": "Diagnostic" },
            { 'id': 'bca80cfd-fcdd-11ef-a39b-00505652cca1', "name": "EPT Analisis", "field": "ept", "type": "Diagnostic" }
        ];
        const activitiesUpdated = [];
        for (const element of addDiagnosticActivitiesDto?.originFieldActivityIds || []) {
            const exist = await this.optimizationActivityRepository.findOne({ where: { originActivity: { id: element }, type: 'Diagnostic' } });
            let variables = [...exist?.variables || []];
            diagnosticVariables.forEach(variable => {
                const existVariableId = variables.findIndex(v => v.id === variable.id);
                if (existVariableId !== -1) {
                    if (!addDiagnosticActivitiesDto[variable.field]) {
                        variables = variables.filter(v => v.id !== variable.id);
                    }
                    else {
                        variables[existVariableId] = {
                            ...variables[existVariableId],
                            value: addDiagnosticActivitiesDto[variable.field]
                        };
                    }
                }
                else if (addDiagnosticActivitiesDto[variable.field] !== null && addDiagnosticActivitiesDto[variable.field] !== undefined) {
                    const value = addDiagnosticActivitiesDto[variable.field];
                    variables.push({
                        id: variable.id,
                        name: variable.name,
                        value,
                        type: variable.type
                    });
                }
            });
            if (addDiagnosticActivitiesDto?.optimizationActivitiesSelected?.length > 0) {
                variables = variables.filter(variable => !['Main Optimization Activity', 'Main Optimization Activity Simulated', 'Optimization info'].includes(variable.name));
                let mainOptimizationInfo = addDiagnosticActivitiesDto?.optimizationActivitiesSelected.find(opt => opt.main === true);
                if (!mainOptimizationInfo) {
                    mainOptimizationInfo = addDiagnosticActivitiesDto?.optimizationActivitiesSelected[0];
                }
                variables.push({
                    id: '',
                    name: 'Main Optimization Activity',
                    value: mainOptimizationInfo?.name,
                    type: 'Diagnostic'
                });
                variables.push({
                    id: '',
                    name: 'Main Optimization Activity Simulated',
                    value: mainOptimizationInfo?.simulated,
                    type: 'Diagnostic'
                });
                variables.push({
                    id: '',
                    name: 'Optimization info',
                    value: addDiagnosticActivitiesDto?.optimizationActivitiesSelected,
                    type: 'Diagnostic'
                });
            }
            let status = status_enum_1.StatusEnum.pending;
            if (addDiagnosticActivitiesDto?.newFieldActivityState === status_enum_1.FieldStatusEnum?.finished) {
                status = status_enum_1.StatusEnum.completed;
            }
            if (addDiagnosticActivitiesDto?.newFieldActivityState === status_enum_1.FieldStatusEnum?.analyzing) {
                status = status_enum_1.StatusEnum.analyzing;
            }
            const updateData = {
                ...exist,
                project: { id: addDiagnosticActivitiesDto.projectId },
                location: { id: addDiagnosticActivitiesDto.locationId },
                originActivity: { id: element },
                requiredUserId: { id: addDiagnosticActivitiesDto.requiredUserId },
                type: 'Diagnostic',
                status,
                variables,
                executedDate: exist?.executedDate || new Date(),
            };
            const updatedActivity = await this.optimizationActivityRepository.save(updateData);
            activitiesUpdated.push(updatedActivity);
            await this.fieldActivityService.updateActivityStatus(element, addDiagnosticActivitiesDto?.newFieldActivityState);
        }
        ;
        return activitiesUpdated;
    }
    async addRequirementToLocation(addRequirementActivityDto) {
        if (addRequirementActivityDto?.optimizationActivityId) {
            const existOptimizationActivity = await this.optimizationActivityRepository.findOne({ where: { id: addRequirementActivityDto?.optimizationActivityId } });
            if (!existOptimizationActivity) {
                throw new common_1.NotFoundException('Optimization Activity not found');
            }
            const optimizationActivity = {
                ...existOptimizationActivity,
                project: { id: addRequirementActivityDto.projectId },
                location: { id: addRequirementActivityDto.locationId },
                requiredUserId: { id: addRequirementActivityDto.requiredUserId },
                requiredAt: addRequirementActivityDto.requiredDate,
                variables: addRequirementActivityDto.requirements
            };
            return this.optimizationActivityRepository.save(optimizationActivity);
        }
        else {
            const existOptimizationAtivityForLocationByUser = await this.optimizationActivityRepository.findOne({
                where: { location: { id: addRequirementActivityDto.locationId }, requiredUserId: { id: addRequirementActivityDto.requiredUserId }, type: addRequirementActivityDto?.type, status: status_enum_1.StatusEnum.pending, originActivity: { id: addRequirementActivityDto.originFieldActivityId } },
            });
            const requirements = [];
            addRequirementActivityDto.requirements.forEach(requirement => {
                requirements.push(requirement);
            });
            existOptimizationAtivityForLocationByUser?.variables.forEach(variable => {
                if (['Requirement', 'Optimization'].includes(variable.type)) {
                    const exist = requirements.find(requirement => requirement.id === variable.id);
                    if (!exist) {
                        requirements.push(variable);
                    }
                }
            });
            const optimizationActivity = {
                id: existOptimizationAtivityForLocationByUser?.id,
                project: { id: addRequirementActivityDto.projectId },
                location: { id: addRequirementActivityDto.locationId },
                originActivity: { id: addRequirementActivityDto.originFieldActivityId },
                requiredUserId: { id: addRequirementActivityDto.requiredUserId },
                type: addRequirementActivityDto.type,
                variables: requirements,
                status: status_enum_1.StatusEnum.pending,
                requiredAt: addRequirementActivityDto.requiredDate,
                createdAt: undefined,
                updatedAt: undefined,
                targetActivity: undefined,
                planningActivity: undefined,
                executedDate: undefined,
                users: undefined
            };
            return this.optimizationActivityRepository.save(optimizationActivity);
        }
    }
    async updateOptimizationActivityStatus(updateActivitySatusDto) {
        const existOptimizationActivity = await this.optimizationActivityRepository.findOne({ where: { id: updateActivitySatusDto.optimizationActivityId } });
        if (!existOptimizationActivity) {
            throw new common_1.NotFoundException('Optimization Activity not found');
        }
        if (existOptimizationActivity.status !== updateActivitySatusDto.newStatus) {
            const updateData = {
                ...existOptimizationActivity,
                status: updateActivitySatusDto.newStatus,
            };
            const activityMessage = {
                activity_id: existOptimizationActivity.id,
                comment: `cambio de estado de ${existOptimizationActivity.status} a ${updateActivitySatusDto.newStatus}, ${updateActivitySatusDto.comments}`,
                executedUser: { id: updateActivitySatusDto.executedUserId },
                previousStatus: existOptimizationActivity.status,
                newStatus: updateActivitySatusDto.newStatus,
            };
            const newActivity = await this.optimizationActivityRepository.save(updateData);
            await this.activityMessageRepository.save(activityMessage);
            return newActivity;
        }
        return existOptimizationActivity;
    }
    async getRequirementById(requirementId) {
        const requirement = await this.optimizationActivityRepository.findOne({ where: { id: requirementId }, relations: ['project', 'originActivity', 'targetActivity', 'planningActivity', 'requiredUserId'] });
        const activityMessage = await this.activityMessageRepository.find({ where: { activity_id: requirementId }, relations: ['executedUser'] });
        const requirements = [];
        const changeHistory = [];
        const relatedActivities = [];
        requirement.variables.forEach(variable => {
            if (variable.type === 'Requirement') {
                requirements.push({
                    id: variable.id,
                    name: variable.name,
                    value: variable.value,
                    type: requirement.type,
                    comments: variable?.comments,
                    blocker: variable?.blocker,
                    status: variable.status
                });
            }
        });
        activityMessage.forEach(message => {
            changeHistory.push({
                date: message.created_at,
                changedBy: message.executedUser?.fullName,
                finalStatus: message.newStatus,
                comments: message.comment
            });
        });
        if (requirement?.originActivity) {
            const type = requirement?.originActivity?.variables.find(variable => variable.id === 'ae5f1c52-da3c-4b0d-80c8-abf6913a966d')?.value;
            const comments = requirement?.originActivity?.variables.find(variable => variable.id === '36b341cf-4c8b-43cb-a2de-4e91a4e988e8')?.value;
            relatedActivities.push({
                executed: requirement?.originActivity?.executedDate,
                activityId: requirement?.originActivity?.id,
                type,
                users: requirement?.originActivity?.users?.map(user => user.name).join(', '),
                comments
            });
        }
        if (requirement?.targetActivity) {
            const type = requirement?.targetActivity?.variables.find(variable => variable.id === 'ae5f1c52-da3c-4b0d-80c8-abf6913a966d')?.value;
            const comments = requirement?.targetActivity?.variables.find(variable => variable.id === '36b341cf-4c8b-43cb-a2de-4e91a4e988e8')?.value;
            relatedActivities.push({
                executed: requirement?.targetActivity?.executedDate,
                activityId: requirement?.targetActivity?.id,
                type,
                users: requirement?.targetActivity?.users?.map(user => user.name).join(', '),
                comments
            });
        }
        if (requirement?.planningActivity) {
            relatedActivities.push({
                executed: requirement?.planningActivity?.endDate,
                activityId: requirement?.planningActivity?.id,
                type: 'Ruta',
                users: requirement?.planningActivity?.groupAssigned,
                comments: requirement?.planningActivity?.description
            });
        }
        const requirementSorted = {
            projectId: requirement?.project?.id,
            projectName: requirement?.project?.name,
            locationId: requirement?.location?.id,
            locationName: requirement?.location?.name,
            Type: requirement?.type,
            status: requirement?.status,
            requiredDate: requirement?.requiredAt,
            plannedStartDate: requirement?.planningActivity?.planningEndDate,
            endDate: requirement?.executedDate,
            requirement: requirements,
            changeHistory: changeHistory,
            relatedActivities: relatedActivities
        };
        return requirementSorted;
    }
    async deleteRequirementFromLocation(body) {
        const existOptimizationActivity = await this.optimizationActivityRepository.findOne({ where: { id: body.optimizationActivityId } });
        if (!existOptimizationActivity) {
            throw new common_1.NotFoundException('Optimization Activity not found');
        }
        let requirements = existOptimizationActivity.variables.filter(variable => variable.type === 'Requirement');
        if (requirements?.length > 0) {
            requirements = requirements.filter(requirement => requirement.id !== body.variableId);
        }
        if (requirements.length === 0) {
            await this.optimizationActivityRepository.delete(body.optimizationActivityId);
        }
        else {
            const updateData = {
                ...existOptimizationActivity,
                variables: requirements
            };
            await this.optimizationActivityRepository.save(updateData);
        }
        return {
            message: 'Requerimiento eliminado',
        };
    }
    async removeOptimizationRequirementWhenDeletePlanningActivity(planningActivityId) {
        try {
            await this.optimizationActivityRepository.createQueryBuilder()
                .update(optimization_activity_entity_1.OptimizationActivityEntity)
                .set({ planningActivity: null })
                .where('planningActivity = :planningActivityId', { planningActivityId })
                .execute();
            return true;
        }
        catch (error) {
            console.log(`Errror [removeOptimizationRequirementWhenDeletePlanningActivity] ${error}`);
            return false;
        }
    }
    async getAnalyzedActivities({ startDate, endDate, projectId }) {
        const queryBuilder = this.optimizationActivityRepository.createQueryBuilder('optimizationActivity')
            .leftJoinAndSelect('optimizationActivity.location', 'location')
            .leftJoinAndSelect('optimizationActivity.requiredUserId', 'requiredUserId')
            .leftJoinAndSelect('optimizationActivity.originActivity', 'originActivity')
            .where('DATE(optimizationActivity.executed_at) >= :start', { start: `${startDate}` })
            .andWhere('DATE(optimizationActivity.executed_at) <= :end', { end: `${endDate}` })
            .andWhere('optimizationActivity.type = :type', { type: 'Diagnostic' });
        if (projectId) {
            queryBuilder.andWhere('optimizationActivity.project = :projectId', { projectId });
        }
        return queryBuilder.getMany();
    }
    async getActivesRequirements({ startDate, endDate, projectId }) {
        const queryBuilder = this.optimizationActivityRepository.createQueryBuilder('optimizationActivity')
            .leftJoinAndSelect('optimizationActivity.location', 'location')
            .leftJoinAndSelect('optimizationActivity.requiredUserId', 'requiredUserId')
            .leftJoinAndSelect('optimizationActivity.originActivity', 'originActivity')
            .where('DATE(optimizationActivity.required_at) >= :start', { start: `${startDate}` })
            .andWhere('DATE(optimizationActivity.required_at) <= :end', { end: `${endDate}` })
            .andWhere('optimizationActivity.type = :type', { type: optimization_activities_type_enum_1.OptimizationActivitiesType.Requirement })
            .andWhere('optimizationActivity.status = :status', { status: status_enum_1.StatusEnum.pending });
        if (projectId) {
            queryBuilder.andWhere('optimizationActivity.project = :projectId', { projectId });
        }
        return queryBuilder.getMany();
    }
    async updateActivityStatusById(ids, status) {
        await this.optimizationActivityRepository.createQueryBuilder()
            .update(optimization_activity_entity_1.OptimizationActivityEntity)
            .set({ status })
            .where('id IN (:...ids)', { ids })
            .execute();
        return this.optimizationActivityRepository.findByIds(ids);
    }
    async getPendingOptimizationActivities(body) {
        const optimizationActivity = [];
        const analists = [];
        const requirements = [];
        const queryBuilder = this.optimizationActivityRepository.createQueryBuilder('optimizationActivity')
            .leftJoinAndSelect('optimizationActivity.location', 'location')
            .leftJoinAndSelect('optimizationActivity.requiredUserId', 'requiredUserId')
            .leftJoinAndSelect('optimizationActivity.originActivity', 'originActivity')
            .leftJoinAndSelect('optimizationActivity.planningActivity', 'planningActivity')
            .where('optimizationActivity.type IN (:...types)', { types: [optimization_activities_type_enum_1.OptimizationActivitiesType.Optimization, optimization_activities_type_enum_1.OptimizationActivitiesType.Diagnostic, optimization_activities_type_enum_1.OptimizationActivitiesType.Requirement] });
        if (body.startDate && body.endDate) {
            queryBuilder.andWhere(`(DATE(optimizationActivity.required_at) BETWEEN :startDate AND :endDate OR DATE(optimizationActivity.executed_at) BETWEEN :startDate AND :endDate)`, { startDate: body.startDate, endDate: body.endDate });
        }
        else if (body.startDate) {
            queryBuilder.andWhere(`(DATE(optimizationActivity.required_at) >= :startDate OR DATE(optimizationActivity.executed_at) >= :startDate)`, { startDate: body.startDate });
        }
        else if (body.endDate) {
            queryBuilder.andWhere(`(DATE(optimizationActivity.required_at) <= :endDate OR DATE(optimizationActivity.executed_at) <= :endDate)`, { endDate: body.endDate });
        }
        if (body.projectId) {
            queryBuilder.andWhere('optimizationActivity.project = :projectId', { projectId: body.projectId });
        }
        let activites = await queryBuilder.getMany();
        const optimizationsRequirements = activites.filter(activity => activity.type === optimization_activities_type_enum_1.OptimizationActivitiesType.Optimization);
        optimizationsRequirements.forEach(activity => {
            const requirementsForActivity = activity.variables.filter(variable => variable.type === 'Optimization') || [];
            requirementsForActivity.forEach(req => {
                const originActivityVariables = activity.originActivity?.variables || [];
                if (body.status) {
                    if (req.status !== body.status) {
                        return;
                    }
                }
                if (body?.method) {
                    if (!activity.location?.method || !body.method.includes(activity.location.method)) {
                        return;
                    }
                }
                if (body?.zone) {
                    if (!activity.location?.zone || !body.zone.includes(activity.location.zone)) {
                        return;
                    }
                }
                optimizationActivity.push({
                    id: `${activity.id}-${req.id}`,
                    optimizationActivityId: activity.id,
                    locationId: activity.location?.id,
                    locationName: activity.location?.name,
                    zone: activity.location?.zone,
                    method: activity?.location?.method,
                    pot: activity.location?.pot,
                    crew: activity.originActivity?.groupAssigned,
                    engineers: originActivityVariables.find(variable => variable.id === 'f2fd9162-145f-41e2-a57a-633469b3514d')?.value,
                    field: activity.location.field,
                    technology: originActivityVariables.find(variable => variable.id === '6d7ad753-bb56-479a-ac5c-d26039113564')?.value,
                    activityType: originActivityVariables.find(variable => variable.id === 'ae5f1c52-da3c-4b0d-80c8-abf6913a966d')?.value,
                    initialActivityState: originActivityVariables.find(variable => variable.id === '26ab4565-c234-45d8-a24a-5328bcaee048')?.value,
                    finalActivityState: originActivityVariables.find(variable => variable.id === 'ad664c23-960c-4c32-a01a-6c4d52593ff9')?.value,
                    fieldComment: originActivityVariables.find(variable => variable.id === '36b341cf-4c8b-43cb-a2de-4e91a4e988e8')?.value,
                    spm: activity.variables.find(variable => variable.id === 'bc32f3f7-980e-4681-aa38-bfae46bbb715')?.value,
                    rpm: activity.variables.find(variable => variable.id === '0f5aebd2-ca08-11ef-9bba-712c8b335d3b')?.value,
                    requiredDate: activity.requiredAt,
                    executionDate: activity.executedDate,
                    state: req.status,
                    requesterUserId: activity.requiredUserId.id,
                    requesterUserName: activity.requiredUserId.fullName,
                    variableName: req.name,
                    variableId: req.id,
                    comments: req.comments,
                    simulationDate: req.simulationDate,
                    productionBefore: req.lastProduction,
                    expectedProduction: req.targetProduction,
                });
            });
        });
        const analystActivities = activites.filter(activity => activity.type === optimization_activities_type_enum_1.OptimizationActivitiesType.Diagnostic);
        analystActivities.forEach(activity => {
            const originActivityVariables = activity.originActivity?.variables || [];
            if (body.status) {
                if (activity.status !== body.status) {
                    return;
                }
            }
            if (body?.method) {
                if (!activity.location?.method || !body.method.includes(activity.location.method)) {
                    return;
                }
            }
            if (body?.zone) {
                if (!activity.location?.zone || !body.zone.includes(activity.location.zone)) {
                    return;
                }
            }
            analists.push({
                optimizationActivityId: activity.id,
                fieldActivityDate: activity.originActivity?.executedDate,
                locationId: activity.location?.id,
                locationName: activity.location?.name,
                method: activity?.location?.method,
                pot: activity.location?.pot,
                fieldActivityStartTime: originActivityVariables.find(variable => variable.id === 'cd1e06fc-016e-424e-a69a-aa82317ec742')?.value,
                fieldActivityEndTime: originActivityVariables.find(variable => variable.id === '987f2fce-1778-4e8c-afeb-a14c5bcffb84')?.value,
                zone: activity.location?.zone,
                crew: activity.originActivity?.groupAssigned,
                engineers: originActivityVariables.find(variable => variable.id === 'f2fd9162-145f-41e2-a57a-633469b3514d')?.value,
                field: activity.location.field,
                technology: originActivityVariables.find(variable => variable.id === '6d7ad753-bb56-479a-ac5c-d26039113564')?.value,
                activityType: originActivityVariables.find(variable => variable.id === 'ae5f1c52-da3c-4b0d-80c8-abf6913a966d')?.value,
                initialActivityState: originActivityVariables.find(variable => variable.id === '26ab4565-c234-45d8-a24a-5328bcaee048')?.value,
                finalActivityState: originActivityVariables.find(variable => variable.id === 'ad664c23-960c-4c32-a01a-6c4d52593ff9')?.value,
                thp: originActivityVariables.find(variable => variable.id === '9438d6fd-bd78-45f1-85d6-476f55e97959')?.value,
                surfaceUnitBrand: originActivityVariables.find(variable => variable.id === '888e49bb-093d-491a-9369-47fbb487678f')?.value,
                surfaceUnitModel: originActivityVariables.find(variable => variable.id === '54add674-1701-414b-a4f9-2021ff91fc15')?.value,
                freePolisRod: originActivityVariables.find(variable => variable.id === 'f536414e-be55-40af-a659-456f177e02e0')?.value,
                strokeLength: originActivityVariables.find(variable => variable.id === 'fdbe935a-c93d-402f-98c0-dc918c4d5999')?.value,
                spm: originActivityVariables.find(variable => variable.id === 'bc32f3f7-980e-4681-aa38-bfae46bbb715')?.value,
                rpm: originActivityVariables.find(variable => variable.id === '0f5aebd2-ca08-11ef-9bba-712c8b335d3b')?.value,
                crankHole: originActivityVariables.find(variable => variable.id === '2696e006-6c5a-4110-b9b8-a9493ebe2ec8')?.value,
                maxLoad: originActivityVariables.find(variable => variable.id === 'fc184d1d-f01f-434b-a7d2-3298b6fdc8c3')?.value,
                minLoad: originActivityVariables.find(variable => variable.id === 'd729470b-b539-4382-a3cd-acd2eba41272')?.value,
                liquidLevel: originActivityVariables.find(variable => variable.id === 'e16b12b8-caa4-11ef-837b-f62cf753b79c')?.value,
                pumpSumergence: originActivityVariables.find(variable => variable.id === 'dc047f53-c916-4840-80a0-27e7a930e378')?.value,
                pip: originActivityVariables.find(variable => variable.id === 'd4a0835c-a4c3-4da6-af69-a6ffa4bf5456')?.value,
                pwf: originActivityVariables.find(variable => variable.id === '9d15ecbd-6aef-42c4-86c5-463c2e2444b5')?.value,
                acusticVelocity: originActivityVariables.find(variable => variable.id === '365b59dc-29a3-4602-89b1-66a05e4c3244')?.value,
                fieldComment: originActivityVariables.find(variable => variable.id === '36b341cf-4c8b-43cb-a2de-4e91a4e988e8')?.value,
                weedsCondition: originActivityVariables.find(variable => variable.id === '4e0eb421-a182-443e-9e76-98c21920c8c9')?.value,
                fozaCondition: originActivityVariables.find(variable => variable.id === '13c4e61a-70ed-47fc-8ef3-18ca42793f77')?.value,
                stuffingBoxStatus: originActivityVariables.find(variable => variable.id === 'fa1edd13-0459-4f93-8892-7b6210394c6d')?.value,
                sonologStatus: originActivityVariables.find(variable => variable.id === '1bcaf659-4922-4669-b911-873f676afd92')?.value,
                secondaryValve4InchStatus: originActivityVariables.find(variable => variable.id === 'f8522c50-b6df-4a3e-b451-3c97a6a290a9')?.value,
                sampleValveStatus: originActivityVariables.find(variable => variable.id === '6bdf8e46-af0b-4893-83f7-2592d4cda08e')?.value,
                brakesStatus: originActivityVariables.find(variable => variable.id === '7af1446d-faeb-4524-a844-1063dc282b21')?.value,
                selectorStatus: originActivityVariables.find(variable => variable.id === '0994d1d8-3f5e-4b15-84a1-ae9392c74b51')?.value,
                vfdAccessStatus: originActivityVariables.find(variable => variable.id === '312b5878-e3d0-11ef-97dc-00505652cca1')?.value,
                headerAccessStatus: originActivityVariables.find(variable => variable.id === '312b5a86-e3d0-11ef-97dc-00505652cca1')?.value,
                wellReespaced: originActivityVariables.find(variable => variable.id === '462b2733-9bc7-4ffe-a3e6-c7eb1516fc22')?.value,
                eptBeforeInValue: originActivityVariables.find(variable => variable.id === '665f840c-2dfd-4d5a-8049-88e79492ecf0')?.value,
                eptAfterInValue: originActivityVariables.find(variable => variable.id === '31ca7464-ef1e-4ad7-8b84-ea7c56b02350')?.value,
                dynoCardTaked: originActivityVariables.find(variable => variable.id === '90d6d4db-d8e2-436d-9385-4ffad7e80aa2')?.value,
                fluidLevelValue: originActivityVariables.find(variable => variable.id === '1e4ebb51-5155-4a64-8d20-892285251e21')?.value,
                pressureTestTaken: originActivityVariables.find(variable => variable.id === 'e377cb89-3cf0-422f-a05b-a17f73187544')?.value,
                valveTesTaken: originActivityVariables.find(variable => variable.id === '8a8c2c05-d3b1-410c-bb3e-a8fd717f0e86')?.value,
                samplesTaken: originActivityVariables.find(variable => variable.id === 'ff60850f-baef-4f8e-a4b7-e59468407748')?.value,
                id: `${activity.id}`,
                analysisDate: activity.executedDate,
                state: activity.status,
                executionDate: activity.executedDate,
                analyzedBy: activity.requiredUserId.fullName,
                analystUserId: activity.requiredUserId.id,
                diagnosis: activity.variables.find(variable => variable.id === '26fd1c80-ec8d-11ef-95e3-00505652cca1')?.value,
                recommendation: activity.variables.find(variable => variable.id === '26fd1ece-ec8d-11ef-95e3-00505652cca1')?.value,
                statusCandidate: activity.variables.find(variable => variable.id === '26fd1f13-ec8d-11ef-95e3-00505652cca1')?.value,
                bottomHoleCondition: activity.variables.find(variable => variable.id === '26fd1f4d-ec8d-11ef-95e3-00505652cca1')?.value,
                subBottomHoleCondition: activity.variables.find(variable => variable.id === '3e545921-fc61-11ef-a39b-00505652cca1')?.value,
                fillageBottomHole: activity.variables.find(variable => variable.id === '26fd1f8a-ec8d-11ef-95e3-00505652cca1')?.value,
                theoreticalProductionAfterEfficiency: activity.variables.find(variable => variable.id === '1a6387e8-05db-11f0-af91-00505652cca1')?.value,
                theoreticalProduction: activity.variables.find(variable => variable.id === '3e545b5c-fc61-11ef-a39b-00505652cca1')?.value,
                pumpEfficiency: activity.variables.find(variable => variable.id === '81047dd8-05d4-11f0-af91-00505652cca1')?.value,
                plungerDiameter: activity.variables.find(variable => variable.id === 'e47fc3c4-fc6f-11ef-a39b-00505652cca1')?.value,
                eptAnalysis: activity.variables.find(variable => variable.id === 'bca80cfd-fcdd-11ef-a39b-00505652cca1')?.value,
                mainOptimizationActivity: activity.variables.find(variable => variable.name === 'Main Optimization Activity')?.value,
                mainOptimizationActivitySimulated: activity.variables.find(variable => variable.name === 'Main Optimization Activity Simulated')?.value,
            });
        });
        const requirementsActivities = activites.filter(activity => activity.type === optimization_activities_type_enum_1.OptimizationActivitiesType.Requirement);
        requirementsActivities.forEach(activity => {
            const requirementsForActivity = activity.variables.filter(variable => variable.type === 'Requirement') || [];
            requirementsForActivity.forEach(req => {
                const originActivityVariables = activity.originActivity?.variables || [];
                if (body.status) {
                    if (req.status !== body.status) {
                        return;
                    }
                }
                if (body?.method) {
                    if (!activity.location?.method || !body.method.includes(activity.location.method)) {
                        return;
                    }
                }
                if (body?.zone) {
                    if (!activity.location?.zone || !body.zone.includes(activity.location.zone)) {
                        return;
                    }
                }
                requirements.push({
                    id: `${activity.id}-${req.id}`,
                    optimizationActivityId: activity.id,
                    locationId: activity.location.id,
                    locationName: activity.location.name,
                    method: activity?.location?.method,
                    zone: activity.location?.zone,
                    pot: activity.location.pot,
                    crew: activity.originActivity?.groupAssigned,
                    engineers: originActivityVariables.find(variable => variable.id === 'f2fd9162-145f-41e2-a57a-633469b3514d')?.value,
                    field: activity.location.field,
                    technology: originActivityVariables.find(variable => variable.id === '6d7ad753-bb56-479a-ac5c-d26039113564')?.value,
                    activityType: originActivityVariables.find(variable => variable.id === 'ae5f1c52-da3c-4b0d-80c8-abf6913a966d')?.value,
                    initialActivityState: originActivityVariables.find(variable => variable.id === '26ab4565-c234-45d8-a24a-5328bcaee048')?.value,
                    finalActivityState: originActivityVariables.find(variable => variable.id === 'ad664c23-960c-4c32-a01a-6c4d52593ff9')?.value,
                    fieldComment: originActivityVariables.find(variable => variable.id === '36b341cf-4c8b-43cb-a2de-4e91a4e988e8')?.value,
                    requiredDate: activity.requiredAt,
                    executionDate: activity.executedDate,
                    state: req.status,
                    requesterUserId: activity.requiredUserId.id,
                    requesterUserName: activity.requiredUserId.fullName,
                    variableName: req.name,
                    variableId: req.id,
                    comments: req.comments,
                    blocker: req.blocker,
                });
            });
        });
        const activitiesSorted = {
            optimizationActivity: optimizationActivity,
            analists,
            requirements
        };
        return activitiesSorted;
    }
};
exports.OptimizationActivityService = OptimizationActivityService;
exports.OptimizationActivityService = OptimizationActivityService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(optimization_activity_entity_1.OptimizationActivityEntity)),
    __param(1, (0, typeorm_1.InjectRepository)(activity_message_entity_1.ActivityMessageEntity)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository,
        field_activity_service_1.FieldActivityService])
], OptimizationActivityService);
//# sourceMappingURL=optimization-activity.service.js.map