"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PlanningActivityEntity = void 0;
const typeorm_1 = require("typeorm");
const project_entity_1 = require("../../projects/entities/project.entity");
const status_enum_1 = require("../../operations/dto/status.enum");
const user_entity_1 = require("../../shared/entities/user.entity");
let PlanningActivityEntity = class PlanningActivityEntity {
};
exports.PlanningActivityEntity = PlanningActivityEntity;
__decorate([
    (0, typeorm_1.PrimaryGeneratedColumn)('uuid'),
    __metadata("design:type", String)
], PlanningActivityEntity.prototype, "id", void 0);
__decorate([
    (0, typeorm_1.Column)('json', { nullable: true }),
    __metadata("design:type", Object)
], PlanningActivityEntity.prototype, "variables", void 0);
__decorate([
    (0, typeorm_1.Column)('json', { nullable: true, name: 'related_activities' }),
    __metadata("design:type", Object)
], PlanningActivityEntity.prototype, "relatedActivities", void 0);
__decorate([
    (0, typeorm_1.Column)({ name: 'group_assigned', length: 50 }),
    __metadata("design:type", String)
], PlanningActivityEntity.prototype, "groupAssigned", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => project_entity_1.ProjectEntity),
    (0, typeorm_1.JoinColumn)({ name: 'project_id' }),
    __metadata("design:type", project_entity_1.ProjectEntity)
], PlanningActivityEntity.prototype, "project", void 0);
__decorate([
    (0, typeorm_1.Column)({ length: 100 }),
    __metadata("design:type", String)
], PlanningActivityEntity.prototype, "type", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'decimal', precision: 5, scale: 2, default: 0.00 }),
    __metadata("design:type", Number)
], PlanningActivityEntity.prototype, "advance", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'enum', enum: status_enum_1.StatusEnum, default: 'pending' }),
    __metadata("design:type", String)
], PlanningActivityEntity.prototype, "status", void 0);
__decorate([
    (0, typeorm_1.Column)('text', { nullable: true }),
    __metadata("design:type", String)
], PlanningActivityEntity.prototype, "description", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'date', nullable: true, name: 'started_date' }),
    __metadata("design:type", Date)
], PlanningActivityEntity.prototype, "startDate", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'date', name: 'end_date' }),
    __metadata("design:type", Date)
], PlanningActivityEntity.prototype, "endDate", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'date', nullable: true, name: 'planning_end_date' }),
    __metadata("design:type", Date)
], PlanningActivityEntity.prototype, "planningEndDate", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => user_entity_1.UserEntity),
    (0, typeorm_1.JoinColumn)({ name: 'assignee_user_id' }),
    __metadata("design:type", user_entity_1.UserEntity)
], PlanningActivityEntity.prototype, "assignedUser", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => user_entity_1.UserEntity),
    (0, typeorm_1.JoinColumn)({ name: 'reporter_user_id' }),
    __metadata("design:type", user_entity_1.UserEntity)
], PlanningActivityEntity.prototype, "reporterUser", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => user_entity_1.UserEntity),
    (0, typeorm_1.JoinColumn)({ name: 'approver_user_id' }),
    __metadata("design:type", user_entity_1.UserEntity)
], PlanningActivityEntity.prototype, "approverUser", void 0);
__decorate([
    (0, typeorm_1.CreateDateColumn)({ name: 'created_at' }),
    __metadata("design:type", Date)
], PlanningActivityEntity.prototype, "createdAt", void 0);
__decorate([
    (0, typeorm_1.UpdateDateColumn)({ name: 'updated_at' }),
    __metadata("design:type", Date)
], PlanningActivityEntity.prototype, "updatedAt", void 0);
exports.PlanningActivityEntity = PlanningActivityEntity = __decorate([
    (0, typeorm_1.Entity)('planning_activity')
], PlanningActivityEntity);
//# sourceMappingURL=planning-activity.entity.js.map