"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PlanningController = void 0;
const common_1 = require("@nestjs/common");
const planning_activity_service_1 = require("./services/planning-activity.service");
const jwt_auth_guard_1 = require("../shared/auth/jwt-auth.guard");
let PlanningController = class PlanningController {
    constructor(planningActivityService) {
        this.planningActivityService = planningActivityService;
    }
    async updatePlanningActivity(updatePlanningActivityDto, req) {
        const userId = req.user.userId;
        return this.planningActivityService.updatePlanningActivity(updatePlanningActivityDto, userId);
    }
    async deletePlanningActivity(body) {
        return this.planningActivityService.deletePlanningActivity(body.taskId);
    }
    async getActivityByProjects(headers) {
        return this.planningActivityService.getListPlanningActivityByProject(headers.projectId, headers.start, headers.end, headers.status);
    }
    async getActivityByUser(headers) {
        return this.planningActivityService.getPlanningActivityById(headers.planningactivityid);
    }
    async updatePlanningActivityStatus(body) {
        return this.planningActivityService.updatePlanningActivityStatus(body);
    }
    async deletePlanningActivityById(headers) {
        return this.planningActivityService.deletePlanningActivityById(headers.planningactivityid);
    }
};
exports.PlanningController = PlanningController;
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Post)('updatePlanningActivity'),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Request)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], PlanningController.prototype, "updatePlanningActivity", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Delete)('deletePlanningActivity'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], PlanningController.prototype, "deletePlanningActivity", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Get)('getListOfActivitiesByProject'),
    __param(0, (0, common_1.Headers)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], PlanningController.prototype, "getActivityByProjects", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Get)('getPlanningActivityById'),
    __param(0, (0, common_1.Headers)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], PlanningController.prototype, "getActivityByUser", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Post)('updatePlanningActivityStatus'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], PlanningController.prototype, "updatePlanningActivityStatus", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Delete)('deletePlanningActivityById'),
    __param(0, (0, common_1.Headers)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], PlanningController.prototype, "deletePlanningActivityById", null);
exports.PlanningController = PlanningController = __decorate([
    (0, common_1.Controller)('planning'),
    __metadata("design:paramtypes", [planning_activity_service_1.PlanningActivityService])
], PlanningController);
//# sourceMappingURL=planning.controller.js.map