import { DeleteResult, Repository } from 'typeorm';
import { PlanningActivityEntity } from '../entities/planning-activity.entity';
import { UpdatePlanningActivityDto, updatePlanningActivityStatusDto } from '../dto/update-planning-activity.dto';
import { ChatsService } from 'src/connectors/services/chats.service';
import { ListPlaningActivityDto, PlanningActivityDto } from '../dto/planing-activity.dto';
import { VariableService } from '../../operations/services/variable.service';
import { LocationsService } from 'src/projects/services/locations.service';
import { ActivityMessageService } from 'src/operations/services/activity-message.service';
import { OptimizationActivityService } from 'src/operations/services/optimization-activity.service';
export declare class PlanningActivityService {
    private readonly planningActivityRepository;
    private readonly chatsService;
    private readonly variableService;
    private readonly locationsService;
    private readonly activityMessageService;
    private readonly optimizationActivityService;
    constructor(planningActivityRepository: Repository<PlanningActivityEntity>, chatsService: ChatsService, variableService: VariableService, locationsService: LocationsService, activityMessageService: ActivityMessageService, optimizationActivityService: OptimizationActivityService);
    updatePlanningActivity(updatePlanningActivityDto: UpdatePlanningActivityDto, userId: string): Promise<PlanningActivityEntity>;
    deletePlanningActivity(taskId: string): Promise<DeleteResult>;
    getPlanningActivityByProject(projectId: string, startDate: Date, endDate: Date, status?: string): Promise<PlanningActivityEntity[]>;
    getListPlanningActivityByProject(projectId: string, startDate: Date, endDate: Date, status: string): Promise<ListPlaningActivityDto[]>;
    getPlanningActivityById(planingId: string): Promise<PlanningActivityDto>;
    getPlanningActivityByLocation(projectId: string, startDate: Date, endDate: Date, status: string): Promise<PlanningActivityEntity[]>;
    updatePlanningActivityStatus(body: updatePlanningActivityStatusDto): Promise<any>;
    deletePlanningActivityById(planningactivityid: any): Promise<any>;
}
