"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PlanningActivityService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const planning_activity_entity_1 = require("../entities/planning-activity.entity");
const chats_service_1 = require("../../connectors/services/chats.service");
const class_validator_1 = require("class-validator");
const variable_service_1 = require("../../operations/services/variable.service");
const locations_service_1 = require("../../projects/services/locations.service");
const status_enum_1 = require("../../operations/dto/status.enum");
const activity_message_service_1 = require("../../operations/services/activity-message.service");
const optimization_activity_service_1 = require("../../operations/services/optimization-activity.service");
let PlanningActivityService = class PlanningActivityService {
    constructor(planningActivityRepository, chatsService, variableService, locationsService, activityMessageService, optimizationActivityService) {
        this.planningActivityRepository = planningActivityRepository;
        this.chatsService = chatsService;
        this.variableService = variableService;
        this.locationsService = locationsService;
        this.activityMessageService = activityMessageService;
        this.optimizationActivityService = optimizationActivityService;
    }
    async updatePlanningActivity(updatePlanningActivityDto, userId) {
        let otherVariable = [];
        let plannedVariables = [];
        let optimizationActivitiesIds = [];
        if (updatePlanningActivityDto?.tecnology) {
            otherVariable = [
                { type: 'Tecnologia', value: updatePlanningActivityDto.tecnology }
            ];
        }
        if (updatePlanningActivityDto.target) {
            otherVariable.push({ type: 'target', value: updatePlanningActivityDto.target });
        }
        if (updatePlanningActivityDto?.requirements) {
            updatePlanningActivityDto.requirements.forEach((r) => {
                if (!optimizationActivitiesIds.includes(r.optimizationActivityId)) {
                    optimizationActivitiesIds.push(r.optimizationActivityId);
                }
            });
            const variables = await this.variableService.findAll();
            const uniqueListOfLocatiosn = updatePlanningActivityDto.requirements.map((v) => v.locationName).filter((value, index, self) => self.indexOf(value) === index);
            const location = await this.locationsService.findAllByNames(uniqueListOfLocatiosn, updatePlanningActivityDto.projectId);
            uniqueListOfLocatiosn.forEach((locationName) => {
                const locationInDb = location.find((l) => l.name === locationName);
                const requirements = updatePlanningActivityDto.requirements.filter((v) => v?.locationName?.toLowerCase() === locationName?.toLowerCase());
                const requirementsForLocation = requirements.map((r) => {
                    const existVariable = variables.find((v) => v.name?.toLowerCase() === r.requirementName?.toLowerCase());
                    if (existVariable) {
                        return {
                            date: r.requiredDate,
                            value: r.value === true ? "Si" : "No",
                            variableId: existVariable.id,
                            variableName: existVariable.name,
                            description: r.description,
                            optimizationActivityId: r.optimizationActivityId,
                            executed: r.executed,
                            requiredBy: r.requiredBy
                        };
                    }
                });
                plannedVariables.push({
                    address: locationInDb.description,
                    locationId: locationInDb.id,
                    locationName: locationInDb.name,
                    requirements: requirementsForLocation
                });
            });
        }
        const updateData = {
            ...updatePlanningActivityDto,
            project: { id: updatePlanningActivityDto.projectId },
            assignedUser: { id: updatePlanningActivityDto.assignedUserId },
            reporterUser: { id: updatePlanningActivityDto.reporterUserId },
            approverUser: { id: updatePlanningActivityDto.approverUserId },
            variables: [...otherVariable, { type: 'Planned', value: plannedVariables }]
        };
        if (optimizationActivitiesIds.length > 0) {
            await this.optimizationActivityService.updateActivityStatusById(optimizationActivitiesIds, status_enum_1.StatusEnum.inProgress);
        }
        return this.planningActivityRepository.save(updateData);
    }
    async deletePlanningActivity(taskId) {
        await this.chatsService.deleteChatByActivity(taskId);
        return await this.planningActivityRepository.delete(taskId);
    }
    async getPlanningActivityByProject(projectId, startDate, endDate, status) {
        const queryBuilder = this.planningActivityRepository.createQueryBuilder('planningActivity')
            .leftJoinAndSelect('planningActivity.project', 'project')
            .leftJoinAndSelect('planningActivity.assignedUser', 'assignedUser')
            .leftJoinAndSelect('planningActivity.reporterUser', 'reporterUser')
            .leftJoinAndSelect('planningActivity.approverUser', 'approverUser');
        let hasWhereClause = false;
        if (projectId) {
            queryBuilder.where('planningActivity.project = :projectId', { projectId });
            hasWhereClause = true;
        }
        if (startDate && endDate) {
            if (hasWhereClause) {
                queryBuilder.andWhere('DATE(planningActivity.startDate) <= :startDate', { startDate });
                queryBuilder.andWhere('DATE(planningActivity.planningEndDate) >= :endDate', { endDate });
            }
            else {
                queryBuilder.where('DATE(planningActivity.startDate) <= :startDate', { startDate });
                queryBuilder.andWhere('DATE(planningActivity.planningEndDate) >= :endDate', { endDate });
                hasWhereClause = true;
            }
        }
        if (status) {
            if (hasWhereClause) {
                queryBuilder.andWhere('planningActivity.status = :status', { status });
            }
            else {
                queryBuilder.where('planningActivity.status = :status', { status });
            }
        }
        return queryBuilder.getMany();
    }
    async getListPlanningActivityByProject(projectId, startDate, endDate, status) {
        const sortTasks = [];
        const planningActivity = await this.getPlanningActivityByProject(projectId, startDate, endDate, status);
        for (const act of planningActivity) {
            const title = act.type;
            const description = act.description;
            const tecnology = act.variables.find((v) => v.type === 'Tecnologia')?.value;
            const plannedRequirements = act.variables.find((v) => v.type === 'Planned')?.value;
            const numberOfRequirements = (0, class_validator_1.isArray)(plannedRequirements) ? plannedRequirements.length : 0;
            sortTasks.push({
                id: act.id,
                title,
                description,
                type: act.type,
                tecnology,
                numberOfRequirements,
                assignedUserId: act?.assignedUser?.id,
                asignedUserName: act?.assignedUser?.fullName,
                asignedGroup: act.groupAssigned,
                status: act.status,
                planningStartDate: act.startDate,
                planningEndDate: act.planningEndDate,
                endData: act.endDate,
                advance: act.advance,
                projectId: act?.project?.id,
            });
        }
        return sortTasks;
    }
    async getPlanningActivityById(planingId) {
        const planningActivity = await this.planningActivityRepository.findOne({ where: { id: planingId }, relations: ['project', 'assignedUser', 'reporterUser', 'approverUser'] });
        if (!planningActivity) {
            throw new common_1.NotFoundException('Planning Activity not found');
        }
        const description = planningActivity?.description || "";
        const tecnology = planningActivity?.variables.find((v) => v.type === 'Tecnologia')?.value || "";
        const plannedRequirementsLocations = planningActivity?.variables.find((v) => v.type === 'Planned')?.value || "";
        const target = planningActivity?.variables.find((v) => v.type === 'target')?.value || "";
        const requirements = [];
        if ((0, class_validator_1.isArray)(plannedRequirementsLocations)) {
            for (const req of plannedRequirementsLocations) {
                const requirementsForLocation = req.requirements;
                requirementsForLocation.forEach((r) => {
                    if (r?.variableName) {
                        requirements.push({
                            locationName: req.locationName,
                            locationId: req.locationId,
                            requirementId: r?.variableId,
                            requirementName: r?.variableName,
                            requiredBy: r.requiredBy,
                            requiredDate: r.date,
                            comments: r.description,
                            executed: r.executed,
                        });
                    }
                });
            }
        }
        console.log({ planningActivity });
        const planningDtoActivity = {
            id: planningActivity?.id,
            groupAssigned: planningActivity?.groupAssigned,
            reporterUserId: planningActivity?.reporterUser?.id,
            reporterUserName: planningActivity?.reporterUser?.fullName,
            approverUserId: planningActivity?.approverUser?.id,
            approverUserName: planningActivity?.approverUser?.fullName,
            assignedUserId: planningActivity?.assignedUser?.id,
            assignedUserName: planningActivity?.assignedUser?.fullName,
            projectId: planningActivity?.project?.id,
            projectName: planningActivity?.project?.name,
            description,
            type: planningActivity.type,
            advance: planningActivity.advance,
            status: planningActivity.status,
            tecnology,
            target,
            startDate: planningActivity.startDate,
            planningEndDate: planningActivity.planningEndDate,
            endDate: planningActivity.endDate,
            chats: [],
            requirements,
            fieldActivities: []
        };
        return planningDtoActivity;
    }
    async getPlanningActivityByLocation(projectId, startDate, endDate, status) {
        throw new common_1.NotFoundException('Not Implemented');
    }
    async updatePlanningActivityStatus(body) {
        try {
            const planningActivity = await this.planningActivityRepository.findOne({ where: { id: body.id } });
            if (!planningActivity) {
                throw new common_1.NotFoundException('Planning Activity not found');
            }
            const requirements = planningActivity.variables?.find((v) => v.type === 'Planned')?.value;
            for (const requirement of body?.requirements) {
                const locationIndex = requirements.findIndex((r) => r.locationId === requirement.locationId);
                const requirementsForLocation = requirements[locationIndex].requirements;
                const requirementIndex = requirementsForLocation.findIndex((r) => r.variableId === requirement.requireTestId);
                if (requirementIndex !== -1) {
                    requirements[locationIndex].requirements[requirementIndex].executed = requirement.executed;
                }
            }
            const relatedActivities = planningActivity.relatedActivities || [];
            const existActivity = relatedActivities.findIndex((r) => r?.date === body.executedDate);
            if (existActivity === -1) {
                relatedActivities.push({
                    date: body.executedDate,
                    executedBy: body.executedBy,
                    comments: body.comments,
                    numberOfRequirementsPlanned: body.numberOfRequirementsPlanned,
                    numberOfRequirementsExecuted: body.numberOfRequirementsExecuted,
                    executedActivities: body.executedActivities,
                    dailyPerformance: body.dailyPerformance,
                    expectedTarget: body.expectedTarget,
                });
            }
            else {
                relatedActivities[existActivity] = {
                    date: body.executedDate,
                    executedBy: body.executedBy,
                    comments: body.comments,
                    numberOfRequirementsPlanned: body.numberOfRequirementsPlanned,
                    numberOfRequirementsExecuted: body.numberOfRequirementsExecuted,
                    executedActivities: body.executedActivities,
                    dailyPerformance: body.dailyPerformance,
                    expectedTarget: body.expectedTarget,
                };
            }
            const newActivity = {
                ...planningActivity,
                advance: body.advance,
                status: body.status,
                variables: [
                    ...planningActivity.variables.filter((v) => v.type !== 'Planned'),
                    { type: 'Planned', value: requirements }
                ],
                relatedActivities
            };
            await this.planningActivityRepository.save(newActivity);
        }
        catch (error) {
            console.log({ error });
        }
        return {
            message: 'activity updated'
        };
    }
    async deletePlanningActivityById(planningactivityid) {
        try {
            const response = await this.optimizationActivityService.removeOptimizationRequirementWhenDeletePlanningActivity(planningactivityid);
            if (response) {
                await this.activityMessageService.deleteActivityMessagesByTaskId(planningactivityid);
                const deleted = await this.planningActivityRepository.delete({ id: planningactivityid });
                return {
                    message: 'activity deleted',
                    id: planningactivityid,
                    deleted,
                };
            }
            else {
                throw new common_1.NotFoundException('Planning Activity not Deleted');
            }
        }
        catch (error) {
            throw new common_1.NotFoundException('Planning Activity not Deleted');
        }
    }
};
exports.PlanningActivityService = PlanningActivityService;
exports.PlanningActivityService = PlanningActivityService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(planning_activity_entity_1.PlanningActivityEntity)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        chats_service_1.ChatsService,
        variable_service_1.VariableService,
        locations_service_1.LocationsService,
        activity_message_service_1.ActivityMessageService,
        optimization_activity_service_1.OptimizationActivityService])
], PlanningActivityService);
//# sourceMappingURL=planning-activity.service.js.map