export declare class DynCardDataDto {
    surfaceCardPossition: string[];
    surfaceCardLoad: string[];
    pumpCardPossition: string[];
    pumpCardLoad: string[];
}
export declare class DynCardsDto {
    fieldActivityId: string;
    executedDate: Date;
    responsable: string;
    typeOfActivity: string;
    comments: string;
    status: string;
    optimizationActivityId: string;
    condition: string;
    fillage: string;
    pumpEfficiency: string;
    activityVariables: any[];
    cardData: DynCardDataDto[];
    diagnosticVariables?: any[];
}
export declare class FluidLevelDto {
    fieldActivityId: string;
    executedDate: Date;
    responsable: string;
    typeOfActivity: string;
    comments: string;
    status: string;
    optimizationActivityId: string;
    liquidLevel: string;
    pip: string;
    pwf: string;
    pumpSumergence: string;
    diagnosticVariables?: any[];
}
export declare class requirementsDto {
    variableId: string;
    optimizationActivityId: string;
    requiredDate: Date;
    activity: string;
    comments: string;
    requiredBy: string;
    requiredById: string;
    status: string;
    executedDate: Date;
    blocker: string[];
    originFieldActivityId: string;
    originFieldActivityExecutedDate: Date;
    simulationDate?: string;
    lastProduction?: string;
    targetProduction?: string;
}
export declare class fieldActivitiesDto {
    executedBy: string;
    typeOfActivity: string;
    comments: string;
    operationInitialStatus: string;
    operationFinalStatus: string;
    executedDate: Date;
    fieldActivityId: string;
    variables: any[];
    status: string;
    optimizationActivityId: string;
    diagnosticVariables?: any[];
}
export declare class LastStatusConditionsDto {
    activityIdLastStatus?: string;
    activityExecutedDateLastStatus?: Date;
    weedStatus?: string;
    brakeStatus?: string;
    sonologStatus?: string;
    stuffingStatus?: string;
    selectorStatus?: string;
    pitStatus?: string;
    sampleValveStatus?: string;
    secondFourthValveStatus?: string;
}
export interface wellboreSchematicsInterface {
    id: string;
    locationName: string;
    programStartDate: Date;
    programEndDate: Date;
    totalDepth: number;
    casingInstallationDate?: Date | string;
    casingDiameter?: number;
    casingSections?: string;
    casingBaseDepth?: number;
    casingGrade?: string;
    casingWeight?: number;
    linerInstallationDate?: Date | string;
    linerDiameter?: number;
    linerGrade?: string;
    linerLength?: number;
    linerTopDepth?: number;
    linerBaseDepth?: number;
    linerWeight?: number;
    pumpInstallationDate?: Date | string;
    pumpSize?: string;
    pumpSerialNumber?: string;
    pumpOuterDiameter?: number;
    plungerDiameter?: number;
    pumpBrand?: string;
    tubingInstallationDate?: Date | string;
    standingValveDepth?: number;
    tubingStandingValveDepth?: number;
    tubingDiameters?: string;
    tubingLength?: number;
    tubingJointsQuantity?: number;
    tubingThreads?: string;
    rodInstallationDate?: Date | string;
    rodStandingValveDepth?: number;
    rodDiameters?: string;
    rodLengths?: number;
    rodsQuantity?: number;
}
export declare class locationDetailsDto {
    locationId: string;
    locationName: string;
    projectId: string;
    pot: number;
    zone: string;
    field: string;
    method: string;
    locationSetPoints: any[];
    locationTags: any[];
    dynsCards: DynCardsDto[];
    fluidLevels: FluidLevelDto[];
    fieldActivities: fieldActivitiesDto[];
    requirements: requirementsDto[];
    optimizationRequirements: requirementsDto[];
    lastStatusConditions?: LastStatusConditionsDto;
    waterTests: any[];
    categoriesChanges: any[];
    subsurfaceJobs: any[];
    wellboreSchematics: wellboreSchematicsInterface[];
}
