"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LocationEntity = void 0;
const field_activity_entity_1 = require("../../operations/entities/field-activity.entity");
const optimization_activity_entity_1 = require("../../operations/entities/optimization-activity.entity");
const typeorm_1 = require("typeorm");
const typeorm_2 = require("typeorm");
const project_entity_1 = require("./project.entity");
const location_category_change_entity_1 = require("../../operations/entities/location-category-change.entity");
const production_test_entity_1 = require("../../operations/entities/production-test.entity");
const water_test_entity_1 = require("../../operations/entities/water-test.entity");
const subsurface_job_entity_1 = require("../../operations/entities/subsurface-job.entity");
const location_tag_entity_1 = require("../../configuration/entities/location-tag.entity");
const wellbore_schematics_entity_1 = require("../../operations/entities/wellbore-schematics.entity");
let LocationEntity = class LocationEntity {
};
exports.LocationEntity = LocationEntity;
__decorate([
    (0, typeorm_1.PrimaryGeneratedColumn)('uuid'),
    __metadata("design:type", String)
], LocationEntity.prototype, "id", void 0);
__decorate([
    (0, typeorm_1.Column)({ length: 100 }),
    __metadata("design:type", String)
], LocationEntity.prototype, "name", void 0);
__decorate([
    (0, typeorm_1.Column)('text', { nullable: true }),
    __metadata("design:type", String)
], LocationEntity.prototype, "description", void 0);
__decorate([
    (0, typeorm_1.Column)('decimal', { precision: 10, scale: 8, nullable: true }),
    __metadata("design:type", Number)
], LocationEntity.prototype, "latitude", void 0);
__decorate([
    (0, typeorm_1.Column)('decimal', { precision: 11, scale: 8, nullable: true }),
    __metadata("design:type", Number)
], LocationEntity.prototype, "longitude", void 0);
__decorate([
    (0, typeorm_1.Column)('text'),
    __metadata("design:type", String)
], LocationEntity.prototype, "method", void 0);
__decorate([
    (0, typeorm_1.Column)('int', { nullable: true, name: 'pot' }),
    __metadata("design:type", Number)
], LocationEntity.prototype, "pot", void 0);
__decorate([
    (0, typeorm_1.Column)('text', { nullable: true }),
    __metadata("design:type", String)
], LocationEntity.prototype, "zone", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'enum', name: 'location_type', enum: ['EF', 'Well'], default: 'EF' }),
    __metadata("design:type", String)
], LocationEntity.prototype, "locationType", void 0);
__decorate([
    (0, typeorm_1.CreateDateColumn)({ name: 'created_at' }),
    __metadata("design:type", Date)
], LocationEntity.prototype, "createdAt", void 0);
__decorate([
    (0, typeorm_1.UpdateDateColumn)({ name: 'updated_at' }),
    __metadata("design:type", Date)
], LocationEntity.prototype, "updatedAt", void 0);
__decorate([
    (0, typeorm_1.Column)('text', { nullable: true }),
    __metadata("design:type", String)
], LocationEntity.prototype, "field", void 0);
__decorate([
    (0, typeorm_2.OneToMany)(() => field_activity_entity_1.FieldActivityEntity, fieldActivity => fieldActivity.location),
    __metadata("design:type", Array)
], LocationEntity.prototype, "fieldActivities", void 0);
__decorate([
    (0, typeorm_2.OneToMany)(() => optimization_activity_entity_1.OptimizationActivityEntity, fieldActivity => fieldActivity.location),
    __metadata("design:type", Array)
], LocationEntity.prototype, "optimizationActivities", void 0);
__decorate([
    (0, typeorm_2.OneToMany)(() => production_test_entity_1.ProductionTestEntity, (productionTest) => productionTest.location),
    __metadata("design:type", Array)
], LocationEntity.prototype, "productionTests", void 0);
__decorate([
    (0, typeorm_1.Column)('json', { nullable: true }),
    __metadata("design:type", Array)
], LocationEntity.prototype, "variables", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => project_entity_1.ProjectEntity),
    (0, typeorm_1.JoinColumn)({ name: 'project_id' }),
    __metadata("design:type", project_entity_1.ProjectEntity)
], LocationEntity.prototype, "project", void 0);
__decorate([
    (0, typeorm_2.OneToMany)(() => location_category_change_entity_1.LocationCategoryChangeEntity, fieldActivity => fieldActivity.location),
    __metadata("design:type", Array)
], LocationEntity.prototype, "categoryChanges", void 0);
__decorate([
    (0, typeorm_2.OneToMany)(() => water_test_entity_1.WaterTestEntity, (waterTest) => waterTest.location),
    __metadata("design:type", Array)
], LocationEntity.prototype, "waterTests", void 0);
__decorate([
    (0, typeorm_2.OneToMany)(() => subsurface_job_entity_1.SubsurfaceJobEntity, (subsurfaceJob) => subsurfaceJob.location),
    __metadata("design:type", Array)
], LocationEntity.prototype, "subsurfaceJobs", void 0);
__decorate([
    (0, typeorm_2.OneToMany)(() => location_tag_entity_1.LocationTagEntity, (locationTag) => locationTag.location),
    __metadata("design:type", Array)
], LocationEntity.prototype, "locationTags", void 0);
__decorate([
    (0, typeorm_2.OneToMany)(() => wellbore_schematics_entity_1.WellboreSchematicsEntity, (locationTag) => locationTag.location),
    __metadata("design:type", Array)
], LocationEntity.prototype, "wellboreSchematics", void 0);
exports.LocationEntity = LocationEntity = __decorate([
    (0, typeorm_1.Entity)('locations')
], LocationEntity);
//# sourceMappingURL=location.entity.js.map