import { ProjectsService } from './services/projects.service';
import { LocationsService } from './services/locations.service';
import { LocationEntity } from './entities/location.entity';
import { ProjectEntity } from './entities/project.entity';
import { LocationsListDto } from './dto/locations-list.dto';
import { locationDetailsDto } from './dto/location-details.dto';
import { AddTagsToLocationDto } from './dto/add-tags.dto';
import { AddSetToLocation, AddSingleSetToLocation } from './dto/add-setpoint-to-location.dto';
export declare class ProjectsController {
    private readonly projectsService;
    private readonly locationsService;
    constructor(projectsService: ProjectsService, locationsService: LocationsService);
    getLocations(projectId: string): Promise<LocationEntity[]>;
    getLocationWithFieldActivity(): Promise<LocationsListDto[]>;
    getLocationById(locationId: string): Promise<locationDetailsDto>;
    addLocation(body: AddSetToLocation): Promise<LocationEntity>;
    getProjectsByManagement(management: string): Promise<ProjectEntity[]>;
    addTagToLocation(body: AddTagsToLocationDto): Promise<LocationEntity>;
    deleteTagFromLocation(body: AddTagsToLocationDto): Promise<LocationEntity>;
    addSetPointToLocation(body: AddSetToLocation): Promise<LocationEntity>;
    addSingleSetPointToLocation(body: AddSingleSetToLocation): Promise<LocationEntity>;
}
