"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProjectsController = void 0;
const common_1 = require("@nestjs/common");
const projects_service_1 = require("./services/projects.service");
const locations_service_1 = require("./services/locations.service");
const jwt_auth_guard_1 = require("../shared/auth/jwt-auth.guard");
const add_tags_dto_1 = require("./dto/add-tags.dto");
const add_setpoint_to_location_dto_1 = require("./dto/add-setpoint-to-location.dto");
let ProjectsController = class ProjectsController {
    constructor(projectsService, locationsService) {
        this.projectsService = projectsService;
        this.locationsService = locationsService;
    }
    async getLocations(projectId) {
        console.log({ projectId });
        if (projectId) {
            return this.locationsService.findAllByProject(projectId);
        }
        return this.locationsService.findAll();
    }
    async getLocationWithFieldActivity() {
        return this.locationsService.findAllWithActivities();
    }
    async getLocationById(locationId) {
        return this.locationsService.findOneWithActivities(locationId);
    }
    async addLocation(body) {
        return this.locationsService.addSetPointToLocation(body);
    }
    async getProjectsByManagement(management) {
        return this.projectsService.findByManagement(management);
    }
    async addTagToLocation(body) {
        return this.locationsService.addTagToLocation(body);
    }
    async deleteTagFromLocation(body) {
        return this.locationsService.deleteTagFromLocation(body);
    }
    async addSetPointToLocation(body) {
        return this.locationsService.addSetPointToLocation(body);
    }
    async addSingleSetPointToLocation(body) {
        return this.locationsService.addSingleSetPointToLocation(body);
    }
};
exports.ProjectsController = ProjectsController;
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Get)('getLocations'),
    __param(0, (0, common_1.Headers)('projectId')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], ProjectsController.prototype, "getLocations", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Get)('getLocationsWithActivities'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], ProjectsController.prototype, "getLocationWithFieldActivity", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Get)('getLocationById'),
    __param(0, (0, common_1.Headers)('locationId')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], ProjectsController.prototype, "getLocationById", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Post)('updateLocationSetPoints'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [add_setpoint_to_location_dto_1.AddSetToLocation]),
    __metadata("design:returntype", Promise)
], ProjectsController.prototype, "addLocation", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Get)('getProjectsByManagement'),
    __param(0, (0, common_1.Query)('managementId')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], ProjectsController.prototype, "getProjectsByManagement", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Post)('addTagToLocation'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [add_tags_dto_1.AddTagsToLocationDto]),
    __metadata("design:returntype", Promise)
], ProjectsController.prototype, "addTagToLocation", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Delete)('deleteTagFromLocation'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [add_tags_dto_1.AddTagsToLocationDto]),
    __metadata("design:returntype", Promise)
], ProjectsController.prototype, "deleteTagFromLocation", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Post)('addSetPointToLocation'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [add_setpoint_to_location_dto_1.AddSetToLocation]),
    __metadata("design:returntype", Promise)
], ProjectsController.prototype, "addSetPointToLocation", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Post)('addSingleSetPointToLocation'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [add_setpoint_to_location_dto_1.AddSingleSetToLocation]),
    __metadata("design:returntype", Promise)
], ProjectsController.prototype, "addSingleSetPointToLocation", null);
exports.ProjectsController = ProjectsController = __decorate([
    (0, common_1.Controller)('projects'),
    __metadata("design:paramtypes", [projects_service_1.ProjectsService,
        locations_service_1.LocationsService])
], ProjectsController);
//# sourceMappingURL=projects.controller.js.map