import { Repository } from 'typeorm';
import { LocationEntity } from '../entities/location.entity';
import { CreateLocationDto } from '../dto/create-location.dto';
import { UpdateLocationDto } from '../dto/update-location.dto';
import { locationDetailsDto } from '../dto/location-details.dto';
import { AddTagsToLocationDto } from '../dto/add-tags.dto';
import { AddSetToLocation, AddSingleSetToLocation } from '../dto/add-setpoint-to-location.dto';
import { VariableService } from 'src/operations/services/variable.service';
export declare class LocationsService {
    private readonly locationRepository;
    private readonly variableService;
    constructor(locationRepository: Repository<LocationEntity>, variableService: VariableService);
    create(createLocationDto: CreateLocationDto): Promise<LocationEntity>;
    findAll(): Promise<LocationEntity[]>;
    findAllByProject(projectId: string): Promise<LocationEntity[]>;
    findAllByNames(locationNames: string[], projectId: string): Promise<LocationEntity[]>;
    findAllWithActivities(): Promise<any[]>;
    findOneWithActivities(locationId: string): Promise<locationDetailsDto>;
    findOne(id: string): Promise<LocationEntity>;
    update(id: string, updateLocationDto: UpdateLocationDto): Promise<LocationEntity>;
    remove(id: string): Promise<void>;
    addTagToLocation({ locationId, comments, variableId }: AddTagsToLocationDto): Promise<LocationEntity>;
    addSetPointToLocation(addSetToLocation: AddSetToLocation): Promise<any>;
    addSingleSetPointToLocation(addSetToLocation: AddSingleSetToLocation): Promise<any>;
    deleteTagFromLocation({ locationId, tagsid }: AddTagsToLocationDto): Promise<any>;
    getLastUpdatedAndNumberOfRecords(): Promise<any>;
}
