"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LocationsService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const location_entity_1 = require("../entities/location.entity");
const status_enum_1 = require("../../operations/dto/status.enum");
const add_setpoint_to_location_dto_1 = require("../dto/add-setpoint-to-location.dto");
const class_validator_1 = require("class-validator");
const variable_service_1 = require("../../operations/services/variable.service");
const validateVariablesBeforeSaving_1 = require("../utils/validateVariablesBeforeSaving");
const optimization_activities_type_enum_1 = require("../../operations/Enum/optimization-activities-type.enum");
let LocationsService = class LocationsService {
    constructor(locationRepository, variableService) {
        this.locationRepository = locationRepository;
        this.variableService = variableService;
    }
    async create(createLocationDto) {
        const location = this.locationRepository.create(createLocationDto);
        return this.locationRepository.save(location);
    }
    async findAll() {
        return this.locationRepository.find({
            select: ['id', 'name', 'description', 'latitude', 'longitude', 'pot', 'zone', 'field']
        });
    }
    async findAllByProject(projectId) {
        return this.locationRepository.find({ where: { project: { id: projectId } }, select: ['id', 'name', 'description', 'latitude', 'longitude', 'pot', 'zone', 'field'] });
    }
    async findAllByNames(locationNames, projectId) {
        return this.locationRepository.find({ where: { name: (0, typeorm_2.In)(locationNames), project: { id: projectId } } });
    }
    async findAllWithActivities() {
        const locationsResult = [];
        const locations = await this.locationRepository.find({
            relations: ['fieldActivities', 'optimizationActivities', 'locationTags'],
            take: 2000
        });
        locations.forEach(location => {
            const locationResult = {
                locationId: location.id,
                locationName: location.name,
                method: location.method,
                pot: location.pot,
                zone: location.zone,
                field: location.field,
                activityId: "",
                executedDate: new Date('2024-01-01'),
                opeStatusInicio: '',
                opeStatusFin: '',
                activity: '',
                cardsWithoutAnalyst: 0,
                pendingLiquidLevel: 0,
            };
            if (Array.isArray(location.fieldActivities)) {
                const lastFieldActivitiesSorted = location.fieldActivities.sort((a, b) => new Date(b.executedDate).getTime() - new Date(a.executedDate).getTime());
                if (lastFieldActivitiesSorted.length > 0) {
                    const lastFieldActivity = lastFieldActivitiesSorted[0];
                    const cardsWithoutAnalyst = location.fieldActivities.filter(fieldActivity => {
                        const carta = fieldActivity?.variables?.find(variable => variable.id === '90d6d4db-d8e2-436d-9385-4ffad7e80aa2')?.value || 'no';
                        if (carta.toLowerCase() === 'true' && fieldActivity.status === 'pending') {
                            return true;
                        }
                        return false;
                    }) || [];
                    const pendingLiquidLevel = location.fieldActivities.filter(fieldActivity => {
                        const carta = fieldActivity?.variables?.find(variable => variable.id === '1e4ebb51-5155-4a64-8d20-892285251e21')?.value || 'no';
                        if (carta.toLowerCase() === 'true' && fieldActivity.status === 'pending') {
                            return true;
                        }
                        return false;
                    }) || [];
                    locationResult.activityId = lastFieldActivity.id;
                    locationResult.executedDate = lastFieldActivity.executedDate;
                    locationResult.opeStatusInicio = lastFieldActivity.variables.find(variable => variable.id === '26ab4565-c234-45d8-a24a-5328bcaee048')?.value || '';
                    locationResult.opeStatusFin = lastFieldActivity.variables.find(variable => variable.id === 'ad664c23-960c-4c32-a01a-6c4d52593ff9')?.value || '';
                    locationResult.activity = lastFieldActivity.variables.find(variable => variable.id === 'ae5f1c52-da3c-4b0d-80c8-abf6913a966d')?.value || '';
                    locationResult.cardsWithoutAnalyst = cardsWithoutAnalyst?.length || 0;
                    locationResult.pendingLiquidLevel = pendingLiquidLevel?.length || 0;
                    let lastFieldActivityLeutertOrEchometer = undefined;
                    lastFieldActivitiesSorted.forEach(fieldActivity => {
                        const activityType = fieldActivity.variables.find(variable => variable.id === 'ae5f1c52-da3c-4b0d-80c8-abf6913a966d');
                        const typeActivitiesToTakeCondition = ['Carta Dinagrafica', 'Estudio Completo', 'Carta Leuter', 'Nivel Dinámico'];
                        if (activityType && typeActivitiesToTakeCondition.includes(activityType.value)) {
                            lastFieldActivityLeutertOrEchometer = fieldActivity;
                            return;
                        }
                    });
                    if (lastFieldActivityLeutertOrEchometer) {
                        locationResult.activityIdLastStatus = lastFieldActivityLeutertOrEchometer.id;
                        locationResult.activityExecutedDateLastStatus = lastFieldActivityLeutertOrEchometer.executedDate;
                        locationResult.weedStatus = lastFieldActivityLeutertOrEchometer.variables.find(variable => variable.id === '4e0eb421-a182-443e-9e76-98c21920c8c9')?.value;
                        locationResult.brakeStatus = lastFieldActivityLeutertOrEchometer.variables.find(variable => variable.id === '7af1446d-faeb-4524-a844-1063dc282b21')?.value;
                        locationResult.sonologStatus = lastFieldActivityLeutertOrEchometer.variables.find(variable => variable.id === '1bcaf659-4922-4669-b911-873f676afd92')?.value;
                        locationResult.stuffingStatus = lastFieldActivityLeutertOrEchometer.variables.find(variable => variable.id === 'fa1edd13-0459-4f93-8892-7b6210394c6d')?.value;
                        locationResult.selector = lastFieldActivityLeutertOrEchometer.variables.find(variable => variable.id === '0994d1d8-3f5e-4b15-84a1-ae9392c74b51')?.value;
                        locationResult.pit = lastFieldActivityLeutertOrEchometer.variables.find(variable => variable.id === '13c4e61a-70ed-47fc-8ef3-18ca42793f77')?.value;
                        locationResult.sampleValve = lastFieldActivityLeutertOrEchometer.variables.find(variable => variable.id === '6bdf8e46-af0b-4893-83f7-2592d4cda08e')?.value;
                        locationResult.secondFourthValve = lastFieldActivityLeutertOrEchometer.variables.find(variable => variable.id === 'f8522c50-b6df-4a3e-b451-3c97a6a290a9')?.value;
                    }
                }
            }
            if (Array.isArray(location.optimizationActivities)) {
                const diagnostics = location?.optimizationActivities?.filter(optimizationActivity => optimizationActivity.type === 'Diagnostic') || [];
                const diagnosticActivitiesSorted = diagnostics.sort((a, b) => new Date(b.updatedAt).getTime() - new Date(a.updatedAt).getTime());
                const lastDiagnosticActivity = diagnosticActivitiesSorted[0];
                const theoricalProduction = lastDiagnosticActivity?.variables?.find(variable => variable.id === '3e545b5c-fc61-11ef-a39b-00505652cca1')?.value;
                const theoricalProductionAdjusted = lastDiagnosticActivity?.variables?.find(variable => variable.id === '1a6387e8-05db-11f0-af91-00505652cca1')?.value;
                const pumpCondition = lastDiagnosticActivity?.variables?.find(variable => variable.id === '26fd1f4d-ec8d-11ef-95e3-00505652cca1')?.value || '';
                const subPumpCondition = lastDiagnosticActivity?.variables?.find(variable => variable.id === '3e545921-fc61-11ef-a39b-00505652cca1')?.value || 0;
                locationResult.theoricalProduction = theoricalProduction;
                locationResult.theoricalProductionAdjusted = theoricalProductionAdjusted;
                locationResult.pumpCondition = pumpCondition;
                locationResult.subPumpCondition = subPumpCondition;
            }
            if (location?.locationTags) {
                const locationTags = location?.locationTags?.map(locTag => {
                    return {
                        id: locTag?.id,
                        name: locTag?.variableName,
                        description: locTag?.comment,
                        type: locTag?.alertType,
                    };
                });
                locationResult.locationTag = locationTags || [];
            }
            locationsResult.push(locationResult);
        });
        return locationsResult;
    }
    async findOneWithActivities(locationId) {
        const location = await this.locationRepository.findOne({
            where: { id: locationId },
            relations: ['project', 'fieldActivities', 'optimizationActivities', 'optimizationActivities.requiredUserId',
                'optimizationActivities', 'optimizationActivities.originActivity',
                'waterTests', 'subsurfaceJobs', 'locationTags', 'locationTags.tag', 'locationTags.tag.variable', 'optimizationActivities.originActivity', 'wellboreSchematics']
        });
        if (!location) {
            throw new common_1.NotFoundException(`Location with ID ${locationId} not found`);
        }
        const fieldActivities = [];
        const lastFieldActivitiesSorted = location.fieldActivities.sort((a, b) => new Date(b.executedDate).getTime() - new Date(a.executedDate).getTime());
        let lastFieldActivityLeutertOrEchometer = undefined;
        lastFieldActivityLeutertOrEchometer = lastFieldActivitiesSorted.find(fieldActivity => {
            const activityType = fieldActivity.variables.find(variable => variable.id === 'ae5f1c52-da3c-4b0d-80c8-abf6913a966d');
            const typeActivitiesToTakeCondition = ['Carta Dinagrafica', 'Estudio Completo', 'Carta Leuter', 'Nivel Dinámico'];
            return activityType && typeActivitiesToTakeCondition.includes(activityType.value);
        });
        const diagnostics = location?.optimizationActivities?.filter(optimizationActivity => optimizationActivity.type === optimization_activities_type_enum_1.OptimizationActivitiesType.Diagnostic) || [];
        location?.fieldActivities.forEach(activity => {
            const users = activity.users.reduce((acc, variable) => {
                return acc + variable.name + ', ';
            }, '');
            const variables = activity.variables?.filter(variable => variable.id !== 'e58e5538-bee9-11ef-bb8c-fdbfc59dc1f2') || [];
            const diagnosticActivity = diagnostics.find(diagnostic => diagnostic.originActivity.id === activity.id);
            fieldActivities.push({
                executedBy: users,
                typeOfActivity: activity.variables.find(variable => variable.id === 'ae5f1c52-da3c-4b0d-80c8-abf6913a966d')?.value || '',
                comments: activity.variables.find(variable => variable.id === '36b341cf-4c8b-43cb-a2de-4e91a4e988e8')?.value || '',
                operationInitialStatus: activity.variables.find(variable => variable.id === '26ab4565-c234-45d8-a24a-5328bcaee048')?.value || '',
                operationFinalStatus: activity.variables.find(variable => variable.id === 'ad664c23-960c-4c32-a01a-6c4d52593ff9')?.value || '',
                executedDate: activity.executedDate,
                fieldActivityId: activity.id,
                variables,
                status: activity?.status,
                optimizationActivityId: diagnosticActivity?.id || '',
                diagnosticVariables: diagnosticActivity?.variables || [],
            });
        });
        const requirements = [];
        const requirementActivities = location?.optimizationActivities?.filter(optimizationActivity => optimizationActivity.type === optimization_activities_type_enum_1.OptimizationActivitiesType.Requirement) || [];
        requirementActivities.forEach(optimizationActivity => {
            const requirementsForActivity = optimizationActivity.variables.filter(variable => variable.type === 'Requirement') || [];
            requirementsForActivity.forEach(req => {
                requirements.push({
                    variableId: req.id,
                    optimizationActivityId: optimizationActivity.id,
                    requiredDate: optimizationActivity.requiredAt,
                    activity: req.name,
                    comments: req.comments,
                    originFieldActivityId: optimizationActivity?.originActivity?.id,
                    originFieldActivityExecutedDate: optimizationActivity?.originActivity?.executedDate,
                    requiredBy: optimizationActivity?.requiredUserId?.fullName,
                    requiredById: optimizationActivity?.requiredUserId?.id,
                    status: req.status,
                    executedDate: optimizationActivity.executedDate,
                    blocker: req.blocker,
                });
            });
        });
        const optimizationRequirements = [];
        const optimizationActivities = location?.optimizationActivities?.filter(optimizationActivity => optimizationActivity.type === optimization_activities_type_enum_1.OptimizationActivitiesType.Optimization) || [];
        optimizationActivities.forEach(optimizationActivity => {
            const requirementsForActivity = optimizationActivity.variables.filter(variable => variable.type === 'Optimization') || [];
            requirementsForActivity.forEach(req => {
                optimizationRequirements.push({
                    variableId: req.id,
                    optimizationActivityId: optimizationActivity.id,
                    requiredDate: optimizationActivity.requiredAt,
                    activity: req.name,
                    comments: req.comments,
                    originFieldActivityId: optimizationActivity?.originActivity?.id,
                    originFieldActivityExecutedDate: optimizationActivity?.originActivity?.executedDate,
                    requiredBy: optimizationActivity?.requiredUserId?.fullName,
                    requiredById: optimizationActivity?.requiredUserId?.id,
                    status: req.status,
                    executedDate: optimizationActivity.executedDate,
                    blocker: req.blocker,
                    simulationDate: req.simulationDate,
                    lastProduction: req.lastProduction,
                    targetProduction: req.targetProduction,
                });
            });
        });
        const dynsCards = [];
        const activitiesWithDynCards = location?.fieldActivities?.filter(fieldActivity => {
            const dynCard = fieldActivity.variables.find(variable => variable.id === '90d6d4db-d8e2-436d-9385-4ffad7e80aa2')?.value || 'false';
            return dynCard === 'true';
        }) || [];
        activitiesWithDynCards.forEach(activity => {
            const diagnosticActivity = diagnostics.find(diagnostic => diagnostic.originActivity.id === activity.id);
            const variables = activity.variables?.filter(variable => variable.id !== 'e58e5538-bee9-11ef-bb8c-fdbfc59dc1f2') || [];
            const users = activity.users.reduce((acc, variable) => {
                return acc + variable.name + ', ';
            }, '');
            let dynCardsRaw = activity?.variables?.find(variable => variable.id === 'e58e5538-bee9-11ef-bb8c-fdbfc59dc1f2')?.value;
            let condition = diagnosticActivity?.variables?.find(variable => variable.id === '26fd1f4d-ec8d-11ef-95e3-00505652cca1')?.value || '';
            let fillage = diagnosticActivity?.variables?.find(variable => variable.id === '26fd1f8a-ec8d-11ef-95e3-00505652cca1')?.value || 0;
            let pumpEfficiency = diagnosticActivity?.variables?.find(variable => variable.id === '81047dd8-05d4-11f0-af91-00505652cca1')?.value || 0;
            if (typeof fillage === 'string') {
                fillage = parseInt(fillage);
            }
            fillage = fillage?.toFixed(0);
            if (dynCardsRaw) {
                const dynCards = JSON.parse(dynCardsRaw);
                dynsCards.push({
                    executedDate: activity.executedDate,
                    fieldActivityId: activity.id,
                    typeOfActivity: activity.variables.find(variable => variable.id === 'ae5f1c52-da3c-4b0d-80c8-abf6913a966d')?.value || '',
                    optimizationActivityId: diagnosticActivity?.id || '',
                    condition,
                    fillage,
                    pumpEfficiency,
                    status: diagnosticActivity?.status || status_enum_1.StatusEnum.pending,
                    activityVariables: variables,
                    responsable: users,
                    comments: activity.variables.find(variable => variable.id === '36b341cf-4c8b-43cb-a2de-4e91a4e988e8')?.value || '',
                    cardData: dynCards,
                    diagnosticVariables: diagnosticActivity?.variables || [],
                });
            }
        });
        const fluidLevels = [];
        const activitiesWithFluidLevels = location?.fieldActivities?.filter(fieldActivity => {
            const liquidLevel = fieldActivity.variables.find(variable => variable.id === '1e4ebb51-5155-4a64-8d20-892285251e21')?.value || 'false';
            return liquidLevel === 'true';
        }) || [];
        activitiesWithFluidLevels.forEach(activity => {
            const diagnosticActivity = diagnostics.find(diagnostic => diagnostic.originActivity.id === activity.id);
            const users = activity.users.reduce((acc, variable) => {
                return acc + variable.name + ', ';
            }, '');
            fluidLevels.push({
                fieldActivityId: activity.id,
                executedDate: activity.executedDate,
                responsable: users,
                comments: activity.variables.find(variable => variable.id === '36b341cf-4c8b-43cb-a2de-4e91a4e988e8')?.value || '',
                liquidLevel: activity.variables.find(variable => variable.id === 'e16b12b8-caa4-11ef-837b-f62cf753b79c')?.value || '',
                pip: activity.variables.find(variable => variable.id === 'd4a0835c-a4c3-4da6-af69-a6ffa4bf5456')?.value || '',
                pwf: activity.variables.find(variable => variable.id === '9d15ecbd-6aef-42c4-86c5-463c2e2444b5')?.value || '',
                pumpSumergence: activity.variables.find(variable => variable.id === 'dc047f53-c916-4840-80a0-27e7a930e378')?.value || '',
                typeOfActivity: activity.variables.find(variable => variable.id === 'ae5f1c52-da3c-4b0d-80c8-abf6913a966d')?.value || '',
                status: diagnosticActivity?.status || status_enum_1.StatusEnum.pending,
                optimizationActivityId: diagnosticActivity?.id || '',
                diagnosticVariables: diagnosticActivity?.variables || [],
            });
        });
        const locationTags = location?.locationTags?.map(locTag => {
            const tag = locTag?.tag;
            const variable = tag?.variable;
            return {
                id: locTag?.id,
                type: "tags",
                tagId: tag?.id,
                variableName: variable?.name,
                variableId: variable?.id,
                tagName: tag?.name,
                comment: locTag?.comment,
                value: locTag?.variableValue,
                alertType: locTag?.alertType,
            };
        });
        const wellboreSchematics = [];
        const wellboreSchematicsSorted = location?.wellboreSchematics?.sort((a, b) => new Date(b.programDate).getTime() - new Date(a.programDate).getTime()) || [];
        for (const ws of wellboreSchematicsSorted) {
            const variables = ws.variables;
            const wellboreSchematic = {
                id: ws.id,
                locationName: location?.name,
                programStartDate: ws.programDate,
                programEndDate: ws.finishedDate,
                totalDepth: variables.find(variable => variable.name === 'Prof Total')?.value || 0,
                standingValveDepth: variables.find(variable => variable.name === 'Profundida de la valvula fija')?.value || 0,
                casingInstallationDate: variables.find(variable => variable.name === 'Fecha Instalacion Revestidor')?.value || '',
                casingDiameter: variables.find(variable => variable.name === 'Diametro Revestidor')?.value || '',
                casingSections: variables.filter(variable => variable.name === 'Tramos de resvestidor')?.value || '',
                casingBaseDepth: variables.find(variable => variable.name === 'Base del revestidor')?.value || 0,
                casingGrade: variables.find(variable => variable.name === 'Grado Revestidor')?.value || '',
                casingWeight: variables.find(variable => variable.name === 'Peso Revestidor')?.value || 0,
                linerInstallationDate: variables.find(variable => variable.name === 'Fecha Instalacion Forro')?.value || '',
                linerDiameter: variables.find(variable => variable.name === 'Diametro Forro')?.value || '',
                linerGrade: variables.find(variable => variable.name === 'Grado Forro')?.value || '',
                linerLength: variables.find(variable => variable.name === 'Longitud Forro')?.value || 0,
                linerTopDepth: variables.find(variable => variable.name === 'Tope Forro')?.value || 0,
                linerBaseDepth: variables.find(variable => variable.name === 'Base Forro')?.value || 0,
                linerWeight: variables.find(variable => variable.name === 'Peso Forro')?.value || 0,
                pumpInstallationDate: variables.find(variable => variable.name === 'Fecha Instalacion de bomba')?.value || '',
                pumpSize: variables.find(variable => variable.name === 'Tamaño de la bomba')?.value || '',
                pumpSerialNumber: variables.find(variable => variable.name === 'serial Bomba')?.value || '',
                pumpOuterDiameter: variables.find(variable => variable.name === 'Diametro exterior bomba')?.value || 0,
                plungerDiameter: variables.find(variable => variable.name === 'Diametro Piston')?.value || 0,
                pumpBrand: variables.find(variable => variable.name === 'Marca de Bomba')?.value || '',
                tubingInstallationDate: variables.find(variable => variable.name === 'fecha instalacion tuberia')?.value || '',
                tubingStandingValveDepth: variables.find(variable => variable.name === 'Prof Valvula Fija de tuberia')?.value || 0,
                tubingDiameters: variables.find(variable => variable.name === 'Diametros Tuberia')?.value || '',
                tubingLength: variables.find(variable => variable.name === 'Longitud Tuberias')?.value || 0,
                tubingJointsQuantity: variables.find(variable => variable.name === 'cantidad de tubos Tuberia')?.value || 0,
                tubingThreads: variables.find(variable => variable.name === 'roscas Tuberia')?.value || '',
                rodInstallationDate: variables.find(variable => variable.name === 'fecha instalacion cabilla')?.value || '',
                rodStandingValveDepth: variables.find(variable => variable.name === 'Prof Valvula Fija de cabilla')?.value || 0,
                rodDiameters: variables.find(variable => variable.name === 'Diametros cabillas')?.value || '',
                rodLengths: variables.find(variable => variable.name === 'Longitud cabillas')?.value || 0,
                rodsQuantity: variables.find(variable => variable.name === 'cantidad de cabillas')?.value || 0,
            };
            wellboreSchematics.push(wellboreSchematic);
        }
        const locationSorted = {
            locationId: location?.id,
            locationName: location?.name,
            projectId: location?.project?.id,
            method: location?.method,
            pot: location?.pot,
            zone: location?.zone,
            field: location?.field,
            locationSetPoints: location?.variables?.filter(x => x.type === "setPoint") || [],
            locationTags: locationTags || [],
            dynsCards,
            fluidLevels,
            fieldActivities,
            requirements,
            optimizationRequirements,
            lastStatusConditions: {},
            waterTests: location?.waterTests || [],
            subsurfaceJobs: location?.subsurfaceJobs || [],
            categoriesChanges: location?.categoryChanges || [],
            wellboreSchematics,
        };
        if (lastFieldActivityLeutertOrEchometer) {
            locationSorted.lastStatusConditions.activityIdLastStatus = lastFieldActivityLeutertOrEchometer.id;
            locationSorted.lastStatusConditions.activityExecutedDateLastStatus = lastFieldActivityLeutertOrEchometer.executedDate;
            locationSorted.lastStatusConditions.weedStatus = lastFieldActivityLeutertOrEchometer.variables.find(variable => variable.id === '4e0eb421-a182-443e-9e76-98c21920c8c9')?.value;
            locationSorted.lastStatusConditions.brakeStatus = lastFieldActivityLeutertOrEchometer.variables.find(variable => variable.id === '7af1446d-faeb-4524-a844-1063dc282b21')?.value;
            locationSorted.lastStatusConditions.sonologStatus = lastFieldActivityLeutertOrEchometer.variables.find(variable => variable.id === '1bcaf659-4922-4669-b911-873f676afd92')?.value;
            locationSorted.lastStatusConditions.stuffingStatus = lastFieldActivityLeutertOrEchometer.variables.find(variable => variable.id === 'fa1edd13-0459-4f93-8892-7b6210394c6d')?.value;
            locationSorted.lastStatusConditions.selectorStatus = lastFieldActivityLeutertOrEchometer.variables.find(variable => variable.id === '0994d1d8-3f5e-4b15-84a1-ae9392c74b51')?.value;
            locationSorted.lastStatusConditions.pitStatus = lastFieldActivityLeutertOrEchometer.variables.find(variable => variable.id === '13c4e61a-70ed-47fc-8ef3-18ca42793f77')?.value;
            locationSorted.lastStatusConditions.sampleValveStatus = lastFieldActivityLeutertOrEchometer.variables.find(variable => variable.id === '6bdf8e46-af0b-4893-83f7-2592d4cda08e')?.value;
            locationSorted.lastStatusConditions.secondFourthValveStatus = lastFieldActivityLeutertOrEchometer.variables.find(variable => variable.id === 'f8522c50-b6df-4a3e-b451-3c97a6a290a9')?.value;
        }
        return locationSorted;
    }
    async findOne(id) {
        const location = await this.locationRepository.findOne({ where: { id } });
        if (!location) {
            throw new common_1.NotFoundException(`Location with ID ${id} not found`);
        }
        return location;
    }
    async update(id, updateLocationDto) {
        await this.locationRepository.update(id, updateLocationDto);
        const updatedLocation = await this.locationRepository.findOne({ where: { id } });
        if (!updatedLocation) {
            throw new common_1.NotFoundException(`Location with ID ${id} not found`);
        }
        return updatedLocation;
    }
    async remove(id) {
        const result = await this.locationRepository.delete(id);
        if (result.affected === 0) {
            throw new common_1.NotFoundException(`Location with ID ${id} not found`);
        }
    }
    async addTagToLocation({ locationId, comments, variableId }) {
        const location = await this.locationRepository.findOne({ where: { id: locationId } });
        if (!location) {
            throw new common_1.NotFoundException(`Location with ID ${locationId} not found`);
        }
        const existTag = location.variables.findIndex(variable => (variable.variableId === variableId));
        const variable = await this.variableService.findOne(variableId);
        if (existTag !== -1) {
            location.variables[existTag].value = comments;
            location.variables[existTag].variableName = variable?.name || 'General';
        }
        else {
            location.variables.push({
                type: 'tags',
                value: comments,
                variableId: variableId,
                variableName: variable?.name || 'General'
            });
        }
        return this.locationRepository.save(location);
    }
    async addSetPointToLocation(addSetToLocation) {
        try {
            const location = await this.locationRepository.findOne({ where: { id: addSetToLocation.locationId } });
            if (!location) {
                throw new common_1.NotFoundException(`Location with ID ${addSetToLocation.locationId} not found`);
            }
            let variables = (0, class_validator_1.isArray)(location?.variables)
                ? location?.variables
                : [];
            for (const element of addSetToLocation?.setPointsToUpdate) {
                const exist = variables.findIndex(variable => variable.id === element.id &&
                    variable.limit.toLowerCase() === element.limit.toLowerCase() &&
                    variable.type.toLowerCase() === add_setpoint_to_location_dto_1.SetPointTypeEnum.SETPOINT.toLowerCase());
                if (exist !== -1) {
                    variables[exist].value = element.value;
                }
                else {
                    variables.push({
                        id: element.id,
                        type: add_setpoint_to_location_dto_1.SetPointTypeEnum.SETPOINT,
                        value: element.value,
                        variableId: element.variable,
                        limit: element.limit
                    });
                }
            }
            for (const element of addSetToLocation?.setPointsToDelete) {
                const setPopintToDelete = variables.findIndex(variable => variable.id === element.id &&
                    variable.limit.toLowerCase() === element.limit.toLowerCase() &&
                    variable.type.toLowerCase() === add_setpoint_to_location_dto_1.SetPointTypeEnum.SETPOINT.toLowerCase());
                if (setPopintToDelete !== -1) {
                    variables.splice(setPopintToDelete, 1);
                }
            }
            const errors = (0, validateVariablesBeforeSaving_1.validateVariablesBeforeSaving)(variables);
            if (errors.length > 0) {
                throw new common_1.NotFoundException(`No se pudo actualizar enpoint debido a los errores , ${errors}`);
            }
            const newLocation = { ...location, variables };
            await this.locationRepository.update(addSetToLocation.locationId, newLocation);
            return {
                locationId: addSetToLocation.locationId,
                message: 'Setpoints Actualizdos'
            };
        }
        catch (error) {
            throw new common_1.NotFoundException(`Error Add setpoint to location with ID ${addSetToLocation.locationId} , ${error}`);
        }
    }
    async addSingleSetPointToLocation(addSetToLocation) {
        try {
            const location = await this.locationRepository.findOne({ where: { id: addSetToLocation.locationId } });
            if (!location) {
                throw new common_1.NotFoundException(`Location with ID ${addSetToLocation.locationId} not found`);
            }
            const currentsVariables = (0, class_validator_1.isArray)(location?.variables) ? location?.variables : [];
            const exist = currentsVariables.findIndex(variable => variable.id === addSetToLocation.setPoint.id &&
                variable.limit === addSetToLocation.setPoint.limit &&
                variable.type.toLowerCase() === add_setpoint_to_location_dto_1.SetPointTypeEnum.SETPOINT.toLowerCase());
            if (exist !== -1) {
                currentsVariables[exist].value = addSetToLocation.setPoint.value;
            }
            else {
                currentsVariables.push({
                    id: addSetToLocation.setPoint.id,
                    type: add_setpoint_to_location_dto_1.SetPointTypeEnum.SETPOINT,
                    value: addSetToLocation.setPoint.value,
                    variableId: addSetToLocation.setPoint.variable,
                    limit: addSetToLocation.setPoint.limit
                });
            }
            const errors = (0, validateVariablesBeforeSaving_1.validateVariablesBeforeSaving)(currentsVariables);
            if (errors.length > 0) {
                throw new common_1.HttpException(`No se pudo actualizar enpoint debido a los errores , ${errors}`, 400);
            }
            const newLocation = { ...location, variables: currentsVariables };
            await this.locationRepository.update(addSetToLocation.locationId, newLocation);
            return {
                locationId: addSetToLocation.locationId,
                message: 'Setpoints Actualizdos'
            };
        }
        catch (error) {
            throw new common_1.HttpException(`Error Agregando setpoint a la location con ID ${addSetToLocation.locationId} , ${error}`, 500);
        }
    }
    async deleteTagFromLocation({ locationId, tagsid }) {
        const location = await this.locationRepository.findOne({ where: { id: locationId } });
        if (!location) {
            throw new common_1.NotFoundException(`Location with ID ${locationId} not found`);
        }
        const variables = [...location.variables];
        const existTag = variables.findIndex(variable => (variable.variableId === tagsid && variable.type === 'tags'));
        variables.splice(existTag, 1);
        await this.locationRepository.save({ ...location, variables: variables });
        return {
            locationId,
            message: 'Tag eliminado'
        };
    }
    async getLastUpdatedAndNumberOfRecords() {
        const lastUpdated = await this.locationRepository
            .createQueryBuilder('location')
            .select('MAX(location.updatedAt)', 'lastUpdated')
            .getRawOne();
        const numberOfRecords = await this.locationRepository
            .createQueryBuilder('location')
            .getCount();
        return {
            lastUpdated: lastUpdated?.lastUpdated || null,
            numberOfRecords,
        };
    }
};
exports.LocationsService = LocationsService;
exports.LocationsService = LocationsService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(location_entity_1.LocationEntity)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        variable_service_1.VariableService])
], LocationsService);
//# sourceMappingURL=locations.service.js.map