import { Repository } from 'typeorm';
import { ProjectEntity } from '../entities/project.entity';
import { UpdateProjectDto } from '../dto/update-project.dto';
import { ManagementEntity } from '../entities/management.entity';
export declare class ProjectsService {
    private readonly projectRepository;
    private readonly managementRepository;
    constructor(projectRepository: Repository<ProjectEntity>, managementRepository: Repository<ManagementEntity>);
    findByManagement(managementId: string): Promise<ProjectEntity[]>;
    findOne(id: string): Promise<ProjectEntity>;
    update(id: string, updateProjectDto: UpdateProjectDto): Promise<ProjectEntity>;
    remove(id: string): Promise<void>;
}
