"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProjectsService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const project_entity_1 = require("../entities/project.entity");
const management_entity_1 = require("../entities/management.entity");
let ProjectsService = class ProjectsService {
    constructor(projectRepository, managementRepository) {
        this.projectRepository = projectRepository;
        this.managementRepository = managementRepository;
    }
    async findByManagement(managementId) {
        const projects = await this.projectRepository.find({
            where: { management: { id: managementId } },
            relations: ['management'],
        });
        if (projects.length === 0) {
            throw new common_1.NotFoundException(`No projects found for Management with ID ${managementId}`);
        }
        return projects;
    }
    async findOne(id) {
        const project = await this.projectRepository.findOne({ where: { id }, relations: ['management'] });
        if (!project) {
            throw new common_1.NotFoundException(`Project with ID ${id} not found`);
        }
        return project;
    }
    async update(id, updateProjectDto) {
        const project = await this.projectRepository.preload({
            id,
            ...updateProjectDto,
        });
        if (!project) {
            throw new common_1.NotFoundException(`Project with ID ${id} not found`);
        }
        if (updateProjectDto.managementId) {
            const management = await this.managementRepository.findOne({ where: { id: updateProjectDto.managementId } });
            if (!management) {
                throw new common_1.NotFoundException(`Management with ID ${updateProjectDto.managementId} not found`);
            }
            project.management = management;
        }
        return this.projectRepository.save(project);
    }
    async remove(id) {
        const result = await this.projectRepository.delete(id);
        if (result.affected === 0) {
            throw new common_1.NotFoundException(`Project with ID ${id} not found`);
        }
    }
};
exports.ProjectsService = ProjectsService;
exports.ProjectsService = ProjectsService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(project_entity_1.ProjectEntity)),
    __param(1, (0, typeorm_1.InjectRepository)(management_entity_1.ManagementEntity)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository])
], ProjectsService);
//# sourceMappingURL=projects.service.js.map