"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateVariablesBeforeSaving = void 0;
const add_setpoint_to_location_dto_1 = require("../dto/add-setpoint-to-location.dto");
const validateVariablesBeforeSaving = (variables) => {
    const errors = [];
    const setPointVariables = variables.filter((variable) => variable.type.toLowerCase() === add_setpoint_to_location_dto_1.SetPointTypeEnum.SETPOINT.toLowerCase()) || [];
    const errorMessages = new Set();
    for (const setPoint of setPointVariables) {
        const upValue = setPointVariables.find((v) => v.id === setPoint.id && v.limit.toLowerCase() === add_setpoint_to_location_dto_1.LimitSetPointEnum.UP.toLowerCase());
        const downValue = setPointVariables.find((v) => v.id === setPoint.id && v.limit.toLowerCase() === add_setpoint_to_location_dto_1.LimitSetPointEnum.DOWN.toLowerCase());
        const averageValue = setPointVariables.find((v) => v.id === setPoint.id && v.limit.toLowerCase() === add_setpoint_to_location_dto_1.LimitSetPointEnum.AVERAGE.toLowerCase());
        if (Number(upValue?.value) < Number(downValue?.value)) {
            errorMessages.add(`Variable ${setPoint.variableId} tiene un limite superior (UP) ${upValue?.value} mayor al limite inferior (DOWN) ${downValue?.value}`);
        }
        if (Number(upValue?.value) < Number(averageValue?.value)) {
            errorMessages.add(`Variable ${setPoint.variableId} tiene un limite superior (UP) ${upValue?.value} menor al promedio (AVERAGE) ${averageValue?.value}`);
        }
        if (Number(downValue?.value) > Number(averageValue?.value)) {
            errorMessages.add(`Variable ${setPoint.variableId} tiene un limite inferior (DOWN) ${downValue?.value} mayor al promedio (AVERAGE) ${averageValue?.value}`);
        }
    }
    errors.push(...errorMessages);
    return errors;
};
exports.validateVariablesBeforeSaving = validateVariablesBeforeSaving;
//# sourceMappingURL=validateVariablesBeforeSaving.js.map