"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateExcelFile = generateExcelFile;
const exceljs_1 = require("exceljs");
const functions_1 = require("../../shared/utils/functions");
async function generateExcelFile(data, report) {
    const config = report?.config?.sharedTemplates;
    const file = 'reporte.xlsx';
    const workbook = new exceljs_1.Workbook();
    const worksheet = workbook.addWorksheet('Reporte Campo');
    const base64 = await (0, functions_1.fetchImageAsBase64)('images/nabe.png');
    const imageId = workbook.addImage({
        base64: base64,
        extension: 'png',
    });
    worksheet.addImage(imageId, {
        tl: { col: 0, row: 0 },
        ext: { width: 300, height: 140 },
    });
    let startCol = 1;
    const startRow = 8;
    const maxCols = 86;
    for (let row = 1; row <= startRow; row++) {
        for (let col = 1; col <= maxCols; col++) {
            const cell = worksheet.getCell(row, col);
            cell.fill = {
                type: 'pattern',
                pattern: 'solid',
                fgColor: { argb: 'FFFFFFFF' },
            };
        }
    }
    const sortHardAtt = config?.hardAttributes?.sort((a, b) => a.order - b.order);
    for (const att of sortHardAtt) {
        const col = (0, functions_1.numberToColumnLetter)(startCol);
        const cell = worksheet.getCell(`${col}$${startRow + 1}`);
        cell.value = att?.name;
        cell.alignment = { horizontal: 'center' };
        cell.fill = { type: 'pattern', pattern: 'solid', fgColor: { argb: att?.color } };
        cell.font = { color: { argb: 'FFFFFFFF' } };
        startCol = startCol + 1;
    }
    const attGroupSorted = config?.attributesGroups.sort((a, b) => a.order - b.order);
    const rowsFields = [];
    for (const attg of attGroupSorted) {
        if (attg?.attributes?.length === 0) {
            continue;
        }
        (0, functions_1.addGroupToWorksheet)(worksheet, attg, startCol, startCol + attg.attributes.length - 1, rowsFields, startRow);
        startCol = startCol + attg.attributes.length;
    }
    const dataRows = [];
    let fileDate = new Date();
    for (const act of data) {
        let startRowForData = 0;
        const col = (0, functions_1.numberToColumnLetter)(startRowForData);
        let fecha = act?.['FECHA'];
        try {
            fecha = new Date(fecha);
            fileDate = fecha;
        }
        catch (error) {
            console.error({ error });
        }
        const row = {
            "FECHA": fecha,
            "Pozo": `${act?.['Pozo']}`,
        };
        for (const field of rowsFields) {
            if (typeof (field?.name) === "string") {
                const value = act?.[field?.name];
                row[field.name] = value;
            }
        }
        dataRows.push(row);
    }
    dataRows.forEach((row, index) => {
        const rowIndex = index + startRow + 2;
        for (const field of Object.keys(row)) {
            const col = (0, functions_1.numberToColumnLetter)(Object.keys(row).indexOf(field) + 1);
            worksheet.getCell(`${col}${rowIndex}`).value = row[field];
        }
    });
    worksheet.eachRow({ includeEmpty: true }, (row) => {
        if (row.number >= startRow) {
            row.eachCell({ includeEmpty: true }, (cell) => {
                cell.border = {
                    top: { style: 'thin' },
                    left: { style: 'thin' },
                    bottom: { style: 'thin' },
                    right: { style: 'thin' }
                };
            });
        }
    });
    const buffer = await workbook.xlsx.writeBuffer();
    const day = String(fileDate.getDate()).padStart(2, '0');
    const month = String(fileDate.getMonth() + 1).padStart(2, '0');
    const year = fileDate.getFullYear();
    const formattedDate = `${day}-${month}-${year}`;
    const blob = new Blob([buffer], { type: 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet' });
    return { filename: `${formattedDate}-report.xlsx`, content: buffer };
}
//# sourceMappingURL=generateExcelFileOperationsGto.js.map