"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mapFromFieldActivityToAnalyst = void 0;
const mapFromFieldActivityToAnalyst = (data, activitiesAnalyzed) => {
    const sortData = [];
    for (const act of data) {
        const variables = act?.variables || [];
        const cuadrilla = variables.find((v) => v?.id === "290aa7b7-299e-48e6-bcae-ad9e083c5cac")?.value || "";
        const ingeniero = variables.find((v) => v?.id === "f2fd9162-145f-41e2-a57a-633469b3514d")?.value || "";
        const tecnologia = variables.find((v) => v?.id === "6d7ad753-bb56-479a-ac5c-d26039113564")?.value || "";
        const tipoActividad = variables.find((v) => v?.id === "ae5f1c52-da3c-4b0d-80c8-abf6913a966d")?.value || "";
        const estadoOperativoInicial = variables.find((v) => v?.id === "26ab4565-c234-45d8-a24a-5328bcaee048")?.value || "";
        const estadoOperativoFinal = variables.find((v) => v?.id === "ad664c23-960c-4c32-a01a-6c4d52593ff9")?.value || "";
        const comentario = variables.find((v) => v?.id === "36b341cf-4c8b-43cb-a2de-4e91a4e988e8")?.value || "";
        const analyzed = activitiesAnalyzed.find((a) => a?.originActivity?.id === act?.id) ? true : false;
        sortData.push({
            fieldActivityId: act.id,
            fecha: act.executedDate,
            pozos: act?.location?.name,
            field: act?.location?.field,
            method: act?.location?.method,
            zone: act?.location?.zone,
            pot: act?.location?.pot,
            cuadrilla,
            ingeniero,
            tecnologia,
            tipoActividad,
            estadoOperativoInicial,
            estadoOperativoFinal,
            comentario,
            analyzed
        });
    }
    return sortData;
};
exports.mapFromFieldActivityToAnalyst = mapFromFieldActivityToAnalyst;
//# sourceMappingURL=mapFromFieldActivitiesToAnalyst.js.map