"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mapFromOptimizactionActivityToDiagnostic = void 0;
const mapFromOptimizactionActivityToDiagnostic = (data) => {
    const sortedData = [];
    for (const act of data) {
        const variables = act?.originActivity?.variables || [];
        const cuadrilla = variables.find((v) => v?.id === "290aa7b7-299e-48e6-bcae-ad9e083c5cac")?.value || "";
        const ingeniero = variables.find((v) => v?.id === "f2fd9162-145f-41e2-a57a-633469b3514d")?.value || "";
        const tecnologia = variables.find((v) => v?.id === "6d7ad753-bb56-479a-ac5c-d26039113564")?.value || "";
        const tipoActividad = variables.find((v) => v?.id === "ae5f1c52-da3c-4b0d-80c8-abf6913a966d")?.value || "";
        const estadoOperativoInicial = variables.find((v) => v?.id === "26ab4565-c234-45d8-a24a-5328bcaee048")?.value || "";
        const estadoOperativoFinal = variables.find((v) => v?.id === "ad664c23-960c-4c32-a01a-6c4d52593ff9")?.value || "";
        const comentario = variables.find((v) => v?.id === "36b341cf-4c8b-43cb-a2de-4e91a4e988e8")?.value || "";
        const diagnosticVariables = act?.variables || [];
        const diagnostico = diagnosticVariables.find((v) => v?.id === "26fd1c80-ec8d-11ef-95e3-00505652cca1")?.value || "";
        const recomendaciones = diagnosticVariables.find((v) => v?.id === "26fd1ece-ec8d-11ef-95e3-00505652cca1")?.value || "";
        const desplazamientoTeorico = diagnosticVariables.find((v) => v?.id === "3e545b5c-fc61-11ef-a39b-00505652cca1")?.value || "";
        const estatusCandidato = diagnosticVariables.find((v) => v?.id === "26fd1f13-ec8d-11ef-95e3-00505652cca1")?.value || "";
        const condicionEquipoFondo = diagnosticVariables.find((v) => v?.id === "26fd1f4d-ec8d-11ef-95e3-00505652cca1")?.value || "";
        const subcondicionEquipoFondo = diagnosticVariables.find((v) => v?.id === "3e545921-fc61-11ef-a39b-00505652cca1")?.value || "";
        const llenadoEquipoFondo = diagnosticVariables.find((v) => v?.id === "26fd1f8a-ec8d-11ef-95e3-00505652cca1")?.value || "";
        const eficienciaEquipoFondo = diagnosticVariables.find((v) => v?.id === "81047dd8-05d4-11f0-af91-00505652cca1")?.value || "";
        const desplazamientoTeoricoPostEficiencia = diagnosticVariables.find((v) => v?.id === "1a6387e8-05db-11f0-af91-00505652cca1")?.value || "";
        sortedData.push({
            fieldActivityId: act?.originActivity?.id,
            fecha: act?.originActivity?.executedDate,
            pozos: act?.location?.name,
            pot: act?.location?.pot,
            field: act?.location?.field,
            method: act?.location?.method,
            zone: act?.location?.zone,
            cuadrilla,
            ingeniero,
            tecnologia,
            tipoActividad,
            estadoOperativoInicial,
            estadoOperativoFinal,
            comentario,
            fechaAnalisis: act?.executedDate,
            analizadoPor: act?.requiredUserId?.fullName,
            diagnostico,
            recomendaciones,
            desplazamientoTeorico,
            estatusCandidato,
            condicionEquipoFondo,
            subcondicionEquipoFondo,
            llenadoEquipoFondo,
            eficienciaEquipoFondo,
            desplazamientoTeoricoPostEficiencia,
            analyzed: true
        });
    }
    return sortedData;
};
exports.mapFromOptimizactionActivityToDiagnostic = mapFromOptimizactionActivityToDiagnostic;
//# sourceMappingURL=mapFromOptimizactionActivityToDiagnostic.js.map