"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mapFromOptimizactionActivityToRequirements = void 0;
const mapFromOptimizactionActivityToRequirements = (data) => {
    const sortedData = [];
    for (const act of data) {
        const requirements = act?.variables;
        const Nivel = requirements?.find((req) => req?.id === "1e4ebb51-5155-4a64-8d20-892285251e21")?.value === 'Si' ? 'Si' : 'No';
        const Carta = requirements?.find((req) => req?.id === "90d6d4db-d8e2-436d-9385-4ffad7e80aa2")?.value === 'Si' ? 'Si' : 'No';
        const Reespaceo = requirements?.find((req) => req?.id === "462b2733-9bc7-4ffe-a3e6-c7eb1516fc22")?.value === 'Si' ? 'Si' : 'No';
        const pv = requirements?.find((req) => req?.id === "8a8c2c05-d3b1-410c-bb3e-a8fd717f0e86")?.value === 'Si' ? 'Si' : 'No';
        const pp = requirements?.find((req) => req?.id === "e377cb89-3cf0-422f-a05b-a17f73187544")?.value === 'Si' ? 'Si' : 'No';
        sortedData.push({
            optimizationActivityId: act?.id,
            locationId: act?.location?.id,
            Locacion: act?.location?.name,
            requeridoPor: act?.requiredUserId?.fullName,
            Nivel,
            Carta,
            Reespaceo,
            "Prueba de Válvula": pv,
            "Prueba Presión": pp
        });
    }
    return sortedData;
};
exports.mapFromOptimizactionActivityToRequirements = mapFromOptimizactionActivityToRequirements;
//# sourceMappingURL=mapFromOptimizactionActivityToRequirements.js.map