"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReportsController = void 0;
const common_1 = require("@nestjs/common");
const reports_service_1 = require("./services/reports.service");
const jwt_auth_guard_1 = require("../shared/auth/jwt-auth.guard");
let ReportsController = class ReportsController {
    constructor(reportsService) {
        this.reportsService = reportsService;
    }
    async getEnabledReports() {
        return this.reportsService.findEnabled();
    }
    async getReportWithData(headers, req) {
        const userId = req.user.userId;
        const props = {
            reportId: headers?.report_id,
            reportCode: headers?.report_code,
            startDate: headers?.start_date,
            endDate: headers?.end_date,
            userId,
            projectId: headers?.project_id
        };
        return this.reportsService.getReportWithData(props);
    }
    async shareReport(headers, req, res) {
        const userId = req.user.userId;
        const props = {
            reportId: headers?.report_id,
            reportCode: headers?.report_code,
            startDate: headers?.start_date,
            endDate: headers?.end_date,
            userId,
            projectId: headers?.project_id,
            mailsToShared: JSON.parse(headers?.emails_to_shared),
            sendEmail: headers?.send_email?.toLowerCase() === "true",
            download: headers?.download?.toLowerCase() === "true"
        };
        const { filename, content } = await this.reportsService.shareReport(props);
        res.setHeader('Content-Disposition', `attachment; filename=${filename}`);
        res.setHeader('Content-Type', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        res.send(content);
    }
    async getDailyReport(headers, req) {
        const userId = req.user.userId;
        const props = {
            reportId: headers?.report_id,
            reportCode: headers?.report_code,
            startDate: headers?.start_date,
            endDate: headers?.end_date,
            userId,
            projectId: headers?.project_id
        };
        return this.reportsService.getDailyReport(props);
    }
    async getWeeklyReport(headers, req) {
        const userId = req.user.userId;
        const props = {
            reportId: headers?.report_id,
            reportCode: headers?.report_code,
            startDate: headers?.start_date,
            endDate: headers?.end_date,
            userId,
            projectId: headers?.project_id
        };
        return this.reportsService.getDailyCloseReport(props);
    }
    async getWellAnalysistReport(headers, req) {
        const userId = req.user.userId;
        const props = {
            reportId: headers?.report_id,
            reportCode: headers?.report_code,
            startDate: headers?.start_date,
            endDate: headers?.end_date,
            userId,
            projectId: headers?.project_id
        };
        return this.reportsService.getWellAnalysistReport(props);
    }
    async getActivesRequirementsReport(headers, req) {
        const userId = req.user.userId;
        const props = {
            reportId: headers?.report_id,
            reportCode: headers?.report_code,
            startDate: headers?.start_date,
            endDate: headers?.end_date,
            userId,
            projectId: headers?.project_id
        };
        return this.reportsService.getActivesRequirements(props);
    }
};
exports.ReportsController = ReportsController;
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Get)('listOfEnabledReports'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], ReportsController.prototype, "getEnabledReports", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Get)('getReportWithData'),
    __param(0, (0, common_1.Headers)()),
    __param(1, (0, common_1.Request)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], ReportsController.prototype, "getReportWithData", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Get)('shareReport'),
    __param(0, (0, common_1.Headers)()),
    __param(1, (0, common_1.Request)()),
    __param(2, (0, common_1.Res)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object, Object]),
    __metadata("design:returntype", Promise)
], ReportsController.prototype, "shareReport", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Get)('getDailyReport'),
    __param(0, (0, common_1.Headers)()),
    __param(1, (0, common_1.Request)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], ReportsController.prototype, "getDailyReport", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Get)('getDailySummaryReport'),
    __param(0, (0, common_1.Headers)()),
    __param(1, (0, common_1.Request)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], ReportsController.prototype, "getWeeklyReport", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Get)('getAnalysisReport'),
    __param(0, (0, common_1.Headers)()),
    __param(1, (0, common_1.Request)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], ReportsController.prototype, "getWellAnalysistReport", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Get)('getActivesRequirementsReport'),
    __param(0, (0, common_1.Headers)()),
    __param(1, (0, common_1.Request)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], ReportsController.prototype, "getActivesRequirementsReport", null);
exports.ReportsController = ReportsController = __decorate([
    (0, common_1.Controller)('reports'),
    __metadata("design:paramtypes", [reports_service_1.ReportsService])
], ReportsController);
//# sourceMappingURL=reports.controller.js.map