import { Repository } from 'typeorm';
import { ReportEntity } from '../entities/report.entity';
import { GetReportWithDataDto, SharedReportWithDataDto } from '../dto/get-report-with-data.dto';
import { FieldActivityService } from '../../operations/services/field-activity.service';
import { OptimizationActivityService } from '../../operations/services/optimization-activity.service';
import { PlanningActivityService } from 'src/planning/services/planning-activity.service';
export declare class ReportsService {
    private readonly reportRepository;
    private readonly fieldActivityService;
    private readonly optimizationActivityService;
    private readonly planningActivityService;
    constructor(reportRepository: Repository<ReportEntity>, fieldActivityService: FieldActivityService, optimizationActivityService: OptimizationActivityService, planningActivityService: PlanningActivityService);
    findEnabled(): Promise<ReportEntity[]>;
    getReportWithData(props: GetReportWithDataDto): Promise<any>;
    shareReport(props: SharedReportWithDataDto): Promise<any>;
    getDailyReport(props: GetReportWithDataDto): Promise<any>;
    getDailyCloseReport(props: GetReportWithDataDto): Promise<any>;
    getWellAnalysistReport(props: GetReportWithDataDto): Promise<any>;
    getActivesRequirements(props: GetReportWithDataDto): Promise<any>;
}
