"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReportsService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const report_entity_1 = require("../entities/report.entity");
const field_activity_service_1 = require("../../operations/services/field-activity.service");
const optimization_activity_service_1 = require("../../operations/services/optimization-activity.service");
const generateExcelFileOperationsGto_1 = require("../functions/generateExcelFileOperationsGto");
const sendEmail_1 = require("../../utils/functions/sendEmail");
const planning_activity_service_1 = require("../../planning/services/planning-activity.service");
const mapFromOptimizactionActivityToDiagnostic_1 = require("../functions/mapFromOptimizactionActivityToDiagnostic");
const mapFromOptimizactionActivityToRequirements_1 = require("../functions/mapFromOptimizactionActivityToRequirements");
const mapFromFieldActivitiesToAnalyst_1 = require("../functions/mapFromFieldActivitiesToAnalyst");
let ReportsService = class ReportsService {
    constructor(reportRepository, fieldActivityService, optimizationActivityService, planningActivityService) {
        this.reportRepository = reportRepository;
        this.fieldActivityService = fieldActivityService;
        this.optimizationActivityService = optimizationActivityService;
        this.planningActivityService = planningActivityService;
    }
    async findEnabled() {
        return this.reportRepository.find({ where: { status: 'enabled' } });
    }
    async getReportWithData(props) {
        const report = await this.reportRepository.findOne({ where: { id: props.reportId } });
        const reportConfig = report?.config;
        let rawActivities = [];
        if (reportConfig?.type === 'field_activity') {
            rawActivities = await this.fieldActivityService.getActivitiesForReport(props?.projectId, props?.startDate, props?.endDate, reportConfig?.originFlowsIds || [], reportConfig?.shouldHaveVariables || []);
        }
        else if (reportConfig?.type === 'optimization_activity') {
        }
        let activitiesForReport = [];
        for (const activity of rawActivities) {
            let activityForReport = {};
            for (const variable of report.variables) {
                try {
                    let value = "";
                    if (variable.path === "activity") {
                        value = activity[variable.fieldName];
                    }
                    if (variable.path === "location") {
                        value = activity.location[variable.fieldName];
                    }
                    if (variable.path === "project") {
                        value = activity.project[variable.fieldName];
                    }
                    if (variable.path === "originFlow") {
                        value = activity.originFlow[variable.fieldName];
                    }
                    if (variable.path === "variable") {
                        const variableForActivity = activity.variables.find((x) => x.id === variable.fieldName);
                        value = variableForActivity?.value !== undefined ? variableForActivity.value : "S/I";
                    }
                    if (typeof value === 'string') {
                        if (value?.toLowerCase() === 'true') {
                            value = true;
                        }
                        else if (value?.toLowerCase() === 'false') {
                            value = false;
                        }
                        if (typeof value === 'boolean') {
                            value = value ? "Si" : "No";
                        }
                    }
                    activityForReport[variable.name] = value;
                }
                catch (error) {
                    console.error(error);
                }
            }
            activitiesForReport.push(activityForReport);
        }
        return activitiesForReport;
    }
    async shareReport(props) {
        const report = await this.reportRepository.findOne({ where: { id: props.reportId } });
        const activities = await this.getReportWithData(props);
        const getExcelToAttach = await (0, generateExcelFileOperationsGto_1.generateExcelFile)(activities, report);
        let answers = [];
        if (props?.sendEmail) {
            for (const email of props.mailsToShared) {
                try {
                    const answer = await (0, sendEmail_1.sendEmail)(email, report.name, 'Report attached', { filename: 'report.xlsx', content: getExcelToAttach.content });
                    answers.push({ email, answer });
                    console.debug({ answer });
                }
                catch (error) {
                    console.error({ error });
                    answers.push({ email, error });
                }
            }
        }
        return { Filename: getExcelToAttach.filename, content: props?.download ? getExcelToAttach.content : null, answers };
    }
    async getDailyReport(props) {
        const defaultScore = [
            { "tecnology": "Leuter Digital", "target": 40 },
            { "tecnology": "Echometer", "target": 12 }
        ];
        const allowTest = [
            { "testId": "1e4ebb51-5155-4a64-8d20-892285251e21", "variableName": "Nivel" },
            { "testId": "90d6d4db-d8e2-436d-9385-4ffad7e80aa2", "variableName": "Carta" },
            { "testId": "e377cb89-3cf0-422f-a05b-a17f73187544", "variableName": "Prueba Presión" },
            { "testId": "8a8c2c05-d3b1-410c-bb3e-a8fd717f0e86", "variableName": "Prueba de Válvula" },
            { "testId": "462b2733-9bc7-4ffe-a3e6-c7eb1516fc22", "variableName": "Reespaceo" },
            { "testId": "ff60850f-baef-4f8e-a4b7-e59468407748", "variableName": "Muestras" },
        ];
        const membersList = {};
        const requirementSort = [];
        const plannedActivities = [];
        const ListOLocationsId = [];
        const activities = await this.getReportWithData(props);
        if (activities.length === 0) {
            return { membersList, plannedActivities };
        }
        activities.forEach((activity) => {
            let integrantes = activity.Ingenieros;
            if (integrantes.includes("/")) {
                integrantes = integrantes.split("/").map((x) => x.trim()).join(" / ");
            }
            const name = integrantes;
            integrantes = `${integrantes}- ${activity.Campo}`;
            if (integrantes in membersList) {
                membersList[integrantes].pozosVisitados += 1;
            }
            else {
                membersList[integrantes] = {
                    name,
                    pozosVisitados: 1
                };
            }
            const locationId = activity.locationId;
            if (!ListOLocationsId.includes(locationId)) {
                ListOLocationsId.push(locationId);
            }
        });
        const planingActivitiesData = await this.planningActivityService.getPlanningActivityByProject(props.projectId, props.startDate, props.endDate);
        Object.keys(membersList).forEach((key) => {
            const actividadesRealizadas = [];
            let plannedActivityTecnology = "No Planificado";
            let pozosProgramados = 0;
            let target = 0;
            const activitiesForTeam = activities.filter((activity) => {
                let normalizedActivityKey = activity.Ingenieros.split("/").map((x) => x.trim()).join(" / ");
                normalizedActivityKey = `${normalizedActivityKey}- ${activity.Campo}`;
                return normalizedActivityKey === key;
            });
            const group_assigned = activitiesForTeam[0].group_assigned;
            const flujo = activitiesForTeam[0].flujo;
            const plannedActivityEntity = planingActivitiesData.find((activity) => activity.groupAssigned === group_assigned);
            if (plannedActivityEntity) {
                plannedActivityTecnology = plannedActivityEntity.variables.find((variable) => variable.type === "Tecnologia").value;
                target = plannedActivityEntity.variables.find((variable) => variable.type === "target").value;
                if (target) {
                    pozosProgramados = target;
                }
                else {
                    const defaultScoreForTecnology = defaultScore.find((x) => x.tecnology === plannedActivityTecnology);
                    if (defaultScoreForTecnology) {
                        pozosProgramados = defaultScoreForTecnology.target;
                    }
                }
            }
            else {
                const defaultScoreForTecnology = defaultScore.find((x) => x.tecnology === activitiesForTeam[0].Tecnologia);
                if (defaultScoreForTecnology) {
                    pozosProgramados = defaultScoreForTecnology.target;
                }
                let tecnologyExecuted = activitiesForTeam.map((x) => x.Tecnologia);
                tecnologyExecuted = new Set(tecnologyExecuted);
                tecnologyExecuted = Array.from(tecnologyExecuted).join(", ");
                plannedActivityTecnology = tecnologyExecuted;
            }
            const tecnologia = activitiesForTeam[0]['Tecnologia'];
            activitiesForTeam.forEach((activity) => {
                if (!actividadesRealizadas.includes(activity['Tipo Actividad'])) {
                    actividadesRealizadas.push(activity['Tipo Actividad']);
                }
            });
            const pozosAportando = activitiesForTeam.filter((activity) => activity['Estado Pozo Final'] === "Aportando");
            const pozosSinAporte = activitiesForTeam.filter((activity) => activity['Estado Pozo Final'] === "Sin Aporte");
            const pozosOperando = activitiesForTeam.filter((activity) => activity['Estado Pozo Final'] === "Operando");
            const pozosIT = activitiesForTeam.filter((activity) => activity['Estado Pozo Final'] === "IT");
            const pozosSinAcceso = activitiesForTeam.filter((activity) => activity['Estado Pozo Final'] === "Sin Acceso");
            const pozosRecolocado = activitiesForTeam.filter((activity) => ((activity['Estado Pozo Inicial'] === "IT" && activity['Estado Pozo Final'] === "Operando") || activity['Estado Pozo Final'] === "Recolocado"));
            const pozosEnObservacion = activitiesForTeam.filter((activity) => activity['Estado Pozo Final'] === "Observación");
            const pozosReespaceados = activitiesForTeam.filter((activity) => activity['Reespaceo'] === "Si");
            const pozosPruebaValvula = activitiesForTeam.filter((activity) => activity['Prueba de Válvula'] === "Si" || activity['Prueba de Válvula'] === "Si");
            const pozosSinProduccion = activitiesForTeam.filter((activity) => activity['Estado Pozo Final'] === "Sin Producción");
            const pozosRestaurados = activitiesForTeam.filter((activity) => (activity['Estado Pozo Final'] === "Restaurado" || activity['Estado Pozo Inicial'] === "IT" && activity['Estado Pozo Final'] === "Aportando"));
            const produccionAsociada = activitiesForTeam.reduce((acc, activity) => {
                const value = activity["POT (BNPD)"];
                if (typeof acc !== "number") {
                    return isNaN(parseInt(value)) ? 0 : parseInt(value);
                }
                const pot = isNaN(parseInt(value)) ? 0 : parseInt(value);
                return acc + pot;
            }, 0);
            const produccion_it = pozosIT.reduce((acc, activity) => {
                const value = activity["POT (BNPD)"];
                if (typeof acc !== "number") {
                    return isNaN(parseInt(value)) ? 0 : parseInt(value);
                }
                const pot = isNaN(parseInt(value)) ? 0 : parseInt(value);
                return acc + pot;
            }, 0);
            const produccion_sin_apporte = pozosSinAporte.reduce((acc, activity) => {
                const value = activity["POT (BNPD)"];
                if (typeof acc !== "number") {
                    return isNaN(parseInt(value)) ? 0 : parseInt(value);
                }
                const pot = isNaN(parseInt(value)) ? 0 : parseInt(value);
                return acc + pot;
            }, 0);
            const produccion_diferida = produccion_it + produccion_sin_apporte;
            const produccion_restaurada = pozosRestaurados.reduce((acc, activity) => {
                const value = activity["POT (BNPD)"];
                if (typeof acc !== "number") {
                    return isNaN(parseInt(value)) ? 0 : parseInt(value);
                }
                const pot = isNaN(parseInt(value)) ? 0 : parseInt(value);
                return acc + pot;
            }, 0);
            const cartas = activitiesForTeam.filter((activity) => activity["Carta"] === "Si");
            const estudiosEchometer = activitiesForTeam.filter((activity) => (activity["Tecnologia"] === "Echometer" && (activity["Nivel"] === "Si" || activity["Carta"] === "Si")));
            const estudiosLeutert = activitiesForTeam.filter((activity) => (activity["Tecnologia"] === "Leuter Digital" && (activity["Carta"] === "Si")));
            const muestras = activitiesForTeam.filter((activity) => (activity["Muestras"] === "Si"));
            const relatedActivity = plannedActivityEntity?.relatedActivities?.find((x) => x.executedBy === key && x.date === activitiesForTeam[0].FECHA);
            membersList[key] = {
                ...membersList[key],
                fecha: activitiesForTeam[0].FECHA,
                actividadesRealizadas,
                tecnologiaPlanificada: plannedActivityTecnology,
                group_assigned,
                flujo,
                tecnologia,
                field: activitiesForTeam[0].Campo,
                pozosProgramados,
                pozosAportando: pozosAportando.length,
                pozosSinAporte: pozosSinAporte.length,
                pozosOperando: pozosOperando.length,
                pozosIT: pozosIT.length,
                pozosSinAcceso: pozosSinAcceso.length,
                pozosRecolocado: pozosRecolocado.length,
                pozosEnObservacion: pozosEnObservacion.length,
                pozosReespaceados: pozosReespaceados.length,
                pozosPruebaValvula: pozosPruebaValvula.length,
                pozosSinProduccion: pozosSinProduccion.length,
                pozosRestaurados: pozosRestaurados.length,
                produccionMonitoreado: produccionAsociada,
                produccionDiferida: produccion_diferida,
                produccionRestaurada: produccion_restaurada,
                cartasRealizadas: cartas.length,
                estudiosEchometer: estudiosEchometer.length,
                estudiosLeutert: estudiosLeutert.length,
                muestras: muestras?.length,
                executedPlanningComment: relatedActivity?.comments
            };
        });
        planingActivitiesData.forEach((activity) => {
            const requirementsActivities = [];
            const plannedLocation = activity.variables.find((variable) => variable.type === "Planned").value;
            const plannedActivityAssignedTo = activities.filter((x) => x.group_assigned === activity.groupAssigned);
            const target = activity.variables.find((variable) => variable.type === "target").value;
            let totalOfPlannedLocations = 0;
            let completedLocations = 0;
            for (const plannedLocations of plannedLocation) {
                const fieldActivity = activities.filter((x) => x.locationId === plannedLocations.locationId);
                let fieldActivityExecuted = fieldActivity[0];
                const requirements = plannedLocations.requirements;
                totalOfPlannedLocations += 1;
                requirements.forEach((requirement) => {
                    let wasExecuted = false;
                    fieldActivity.forEach((x) => {
                        if (`${x[requirement.variableName]}`.toLowerCase() === `${requirement.value}`?.toLowerCase()) {
                            fieldActivityExecuted = x;
                            wasExecuted = true;
                            completedLocations += 1;
                        }
                    });
                    requirementsActivities.push({
                        optimizationActivity: requirement?.optimizationActivityId,
                        locationId: plannedLocations?.locationId,
                        location: plannedLocations?.locationName,
                        requireTest: requirement?.variableName,
                        requireTestId: requirement?.variableId,
                        requiredDate: requirement?.date,
                        executed: wasExecuted,
                        visited: fieldActivity.length > 0,
                        wasPlanned: true,
                        fieldActivityId: fieldActivityExecuted?.id,
                        requiredComment: requirement?.description,
                        activityVariables: fieldActivityExecuted
                    });
                });
            }
            const activitiesForTeam = activities.filter((act) => act.group_assigned === activity.groupAssigned);
            for (const act of activitiesForTeam) {
                allowTest.forEach((test) => {
                    if (act[test.variableName] === "Si") {
                        const wasInRequirements = requirementsActivities.find((x) => x.locationId === act?.locationId && x.requireTestId === test.testId);
                        if (!wasInRequirements) {
                            requirementsActivities.push({
                                optimizationActivity: activity.id,
                                locationId: act?.locationId,
                                location: act?.Pozo,
                                requireTest: test.variableName,
                                requireTestId: test.testId,
                                requiredDate: undefined,
                                executed: true,
                                visited: true,
                                wasPlanned: false,
                                fieldActivityId: act?.id,
                                requiredComment: "No Requerido",
                                activityVariables: act
                            });
                        }
                    }
                });
            }
            const activityPlannedSorted = {
                activityId: activity.id,
                executedBy: plannedActivityAssignedTo[0]?.Ingenieros,
                planningEndDate: activity.planningEndDate,
                groupAssigned: activity.groupAssigned,
                plannedActivities: totalOfPlannedLocations,
                executedPlannedActivities: completedLocations,
                tempFieldAdvance: Math.round((plannedActivityAssignedTo?.length / totalOfPlannedLocations) * 100),
                executedFieldActivities: plannedActivityAssignedTo?.length,
                advanced: activity.advance,
                status: activity.status,
                target: target,
                description: activity.description,
                requirements: requirementsActivities,
                relatedActivities: activity.relatedActivities
            };
            plannedActivities.push(activityPlannedSorted);
        });
        return { membersList, plannedActivities };
    }
    async getDailyCloseReport(props) {
        const fields = [
            { "name": "Lagunillas", "id": "e6c51ece-b7db-11ef-bebc-22937bb103f9" },
            { "name": "Bachaquero", "id": "e8de6828-b7db-11ef-bebc-22937bb103f9" }
        ];
        const statesToFilter = [
            { name: "operandoConAporte", "states": ["Aportando", "Recolocado"], "fieldName": "Estado Pozo Final", "uniques": true },
            { name: "restaurados", "states": ["Restaurado"], "fieldName": "Estado Pozo Final", "uniques": true },
            { name: "enObservacion", "states": ["Observación"], "fieldName": "Estado Pozo Final", "uniques": true },
            { name: "sinAcceso", "states": ["Sin Acceso"], "fieldName": "Estado Pozo Final", "uniques": true },
            { name: "it", "states": ["IT"], "fieldName": "Estado Pozo Final", "uniques": true },
            { name: "operandoSinAporte", "states": ["Operando", "Sin Producción", "Sin Aporte"], "fieldName": "Estado Pozo Final", "uniques": true },
            { name: "pozosRestaurados", "states": ["Restaurado"], "fieldName": "Estado Pozo Final" },
            { name: "pozosReespaceados", "states": ["Si"], "fieldName": "Reespaceo" },
            { name: "pozosStufingBueno", "states": ["OK"], "fieldName": "Stuffing", "uniques": true },
            { name: "pozosStufingMalo", "states": ["Empacar"], "fieldName": "Stuffing", "uniques": true },
            { name: "pozosSelectorBueno", "states": ["Si"], "fieldName": "Selector", "uniques": true },
            { name: "pozosSelectorMalo", "states": ["Malo"], "fieldName": "Selector", "uniques": true },
            { name: "pozosValvulaTomaMuestraBuenos", "states": ["OK"], "fieldName": "Válvula Toma Muestra", "uniques": true },
            { name: "pozosValvulaTomaMuestraMalos", "states": ["Dañada", "No Tiene", "Sin volante", "Sin manivela", "enterrada"], "fieldName": "Válvula Toma Muestra", "uniques": true },
            { name: "pozosSonologBueno", "states": ["OK"], "fieldName": "Sonolog", "uniques": true },
            { name: "pozosSonologMalo", "states": ["Petrolizada", "Enterrada", "Toma Clandestina", "Sumergida", "Sin Facilidad", "Dañada", "No", "Mal estado", "tapado"], "fieldName": "Sonolog", "uniques": true },
            { name: "pozosValvula2da4Buenos", "states": ["OK"], "fieldName": "Valvula 2da de 4", "uniques": true },
            { name: "pozosValvula2da4Malos", "states": ["Enterrada", "Sin Volante", "Dañada", "No", "tapado", "sin manivelá"], "fieldName": "Valvula 2da de 4", "uniques": true },
            { name: "pozosFrenosBuenos", "states": ["OK"], "fieldName": "Frenos", "uniques": true },
            { name: "pozosFrenosMalos", "states": ["Malos"], "fieldName": "Frenos", "uniques": true },
            { name: "pozosNivelDinamicoBCP", "states": ["Nivel Dinámico"], "fieldName": "Tipo Actividad", "originFlowId": ["a6da0d56-ca00-11ef-9bba-712c8b335d3b"] },
            { name: "pozosNivelEstaticoBCP", "states": ["Nivel Estático"], "fieldName": "Tipo Actividad", "originFlowId": ["a6da0d56-ca00-11ef-9bba-712c8b335d3b"] },
            { name: "pozosRevisionBCP", "states": ["Revisión"], "fieldName": "Tipo Actividad", "originFlowId": ["a6da0d56-ca00-11ef-9bba-712c8b335d3b"] },
            { name: "pozosCartasLeuter", "states": ["Carta Leuter"], "fieldName": "Tipo Actividad", "originFlowId": ["63624ddd-41c7-45df-8d12-805eb644268c"] },
            { name: "pozosRevisionLeuter", "states": ["Revisión"], "fieldName": "Tipo Actividad", "originFlowId": ["63624ddd-41c7-45df-8d12-805eb644268c"] },
            { name: "pozosEstudiosCompletosEchometer", "states": ["Estudio Completo"], "fieldName": "Tipo Actividad", "originFlowId": ["5929f816-89c5-4828-9ea3-4ff54be008e3"] },
            { name: "pozosCartasEchometer", "states": ["Carta Dinagrafica"], "fieldName": "Tipo Actividad", "originFlowId": ["5929f816-89c5-4828-9ea3-4ff54be008e3"] },
            { name: "pozosNivelDinamicoEchometer", "states": ["Nivel Dinámico"], "fieldName": "Tipo Actividad", "originFlowId": ["5929f816-89c5-4828-9ea3-4ff54be008e3"] },
            { name: "pozosNivelEstaticoEchometer", "states": ["Nivel Estático"], "fieldName": "Tipo Actividad", "originFlowId": ["5929f816-89c5-4828-9ea3-4ff54be008e3"] },
            { name: "pozosRevisionEchometer", "states": ["Revisión"], "fieldName": "Tipo Actividad", "originFlowId": ["5929f816-89c5-4828-9ea3-4ff54be008e3"] }
        ];
        const response = {};
        for (const field of fields) {
            const fieldResponse = {};
            const activities = await this.getReportWithData({ ...props, projectId: field.id });
            for (const state of statesToFilter) {
                let filterActivities = activities;
                if (state?.uniques) {
                    const sortActivities = activities.sort((a, b) => new Date(b.FECHA).getTime() - new Date(a.FECHA).getTime());
                    const uniquePozos = new Set();
                    filterActivities = sortActivities.filter((activity) => {
                        if (uniquePozos.has(activity.Pozo)) {
                            return false;
                        }
                        uniquePozos.add(activity.Pozo);
                        return true;
                    });
                }
                const pozos = filterActivities.filter((act) => {
                    if (state.originFlowId) {
                        return [...state.states].includes(act[state.fieldName]) && state.originFlowId.includes(act.originFlowId);
                    }
                    return [...state.states].includes(act[state.fieldName]);
                });
                const pot = pozos.reduce((acc, activity) => {
                    const value = activity["POT (BNPD)"];
                    if (typeof acc !== "number") {
                        return isNaN(parseInt(value)) ? 0 : parseInt(value);
                    }
                    const pot = isNaN(parseInt(value)) ? 0 : parseInt(value);
                    return acc + pot;
                }, 0);
                fieldResponse[`${state.name}`] = pozos.length || 0;
                fieldResponse[`pot${state.name}`] = pot || 0;
            }
            response[field.name] = fieldResponse;
        }
        return response;
    }
    async getWellAnalysistReport(props) {
        const activitiesAnalyzed = await this.optimizationActivityService.getAnalyzedActivities(props);
        const activitiesShouldBeAnalyzed = await this.fieldActivityService.getActivitiesForAnalyst(props?.projectId, props?.startDate, props?.endDate);
        return {
            analyzed: (0, mapFromOptimizactionActivityToDiagnostic_1.mapFromOptimizactionActivityToDiagnostic)(activitiesAnalyzed),
            activitiesShouldBeAnalyzed: (0, mapFromFieldActivitiesToAnalyst_1.mapFromFieldActivityToAnalyst)(activitiesShouldBeAnalyzed, activitiesAnalyzed)
        };
    }
    async getActivesRequirements(props) {
        const activities = await this.optimizationActivityService.getActivesRequirements(props);
        return (0, mapFromOptimizactionActivityToRequirements_1.mapFromOptimizactionActivityToRequirements)(activities);
    }
};
exports.ReportsService = ReportsService;
exports.ReportsService = ReportsService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(report_entity_1.ReportEntity)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        field_activity_service_1.FieldActivityService,
        optimization_activity_service_1.OptimizationActivityService,
        planning_activity_service_1.PlanningActivityService])
], ReportsService);
//# sourceMappingURL=reports.service.js.map