"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FormsValidationsService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const forms_validations_entity_1 = require("../entities/forms-validations.entity");
const origin_flow_variables_service_1 = require("../../configuration/services/origin-flow-variables.service");
const configuration_service_1 = require("./configuration.service");
let FormsValidationsService = class FormsValidationsService {
    constructor(formsValidationsRepository, originFlowVariablesService, configurationService) {
        this.formsValidationsRepository = formsValidationsRepository;
        this.originFlowVariablesService = originFlowVariablesService;
        this.configurationService = configurationService;
    }
    async getFormsValidations(code, fromModuleVersion) {
        const formValidation = await this.formsValidationsRepository.findOne({ where: { code } });
        const getConfigForForms = await this.configurationService.findByCode('ENABLE_UPLOAD_ORIGIN_FLOW');
        const configFormForVersion = getConfigForForms?.jsonConfig?.[fromModuleVersion]?.find((config) => config.name === code);
        const relations = formValidation?.jsonField?.relations || [];
        const originFlowId = formValidation?.jsonField?.originFlowId;
        let variables = [];
        if (relations?.includes('variables')) {
            const formVariables = formValidation?.jsonField?.variables || [];
            const generalVariables = formVariables.filter(variable => variable.path !== 'variable');
            const variableByOriginFlow = await this.originFlowVariablesService.getOriginFlowVariablesWithRelations(originFlowId);
            for (const variable of variableByOriginFlow) {
                const existCustomValidation = formVariables.find(formVariable => formVariable.id === variable.id);
                if (existCustomValidation) {
                    const options = variable.options.map(option => {
                        const existCustomOption = existCustomValidation.options.find(customOption => customOption.id === option.id);
                        if (existCustomValidation.path === 'config') {
                            const enableOptions = configFormForVersion?.[variable.id];
                            if (!enableOptions.includes(option.value)) {
                                return undefined;
                            }
                        }
                        return {
                            id: option.id,
                            value: option.value,
                            required: existCustomOption?.required || option.required,
                            homologation: option.homologation,
                            dependence: existCustomOption?.dependence || null,
                            mandatoryOptions: existCustomOption?.mandatoryOptions || []
                        };
                    });
                    variables.push({
                        id: variable.id,
                        name: variable.name,
                        homologation: variable.homologation,
                        path: existCustomValidation?.path || variable.path,
                        subPath: existCustomValidation?.subPath || variable.subPath,
                        validationType: existCustomValidation?.validationType || variable.validationType,
                        required: existCustomValidation?.required || variable.required,
                        options: options.filter(option => option !== undefined),
                        dependence: existCustomValidation?.dependence || undefined,
                        mandatoryOptions: existCustomValidation?.mandatoryOptions || [],
                        type: existCustomValidation?.type || 'variable',
                        position: existCustomValidation?.position || variable.position,
                        extraconfig: existCustomValidation?.extraconfig || {},
                    });
                }
                else {
                    variables.push({ ...variable, type: 'variable', position: variable?.position || 99 });
                }
            }
            generalVariables.forEach(variable => {
                const exist = variables.find(v => v.id === variable.id);
                if (!exist) {
                    variables.push({ ...variable, position: variable?.position || 99 });
                }
            });
        }
        return variables;
    }
    async getLastUpdatedAndNumberOfRecords() {
        const lastUpdated = await this.formsValidationsRepository
            .createQueryBuilder('form')
            .select('MAX(form.updatedAt)', 'lastUpdated')
            .getRawOne();
        const numberOfRecords = await this.formsValidationsRepository
            .createQueryBuilder('form')
            .getCount();
        return {
            lastUpdated: lastUpdated?.lastUpdated || null,
            numberOfRecords,
        };
    }
    async getAllFormsValidationsForMobile() {
        const formsValidations = await this.formsValidationsRepository.find({
            where: { isMobile: true },
            order: { updatedAt: 'DESC' },
        });
        const formsValidationsWithRelations = [];
        for (const form of formsValidations) {
            const formValidation = await this.getFormsValidations(form.code, 'mobileV1');
            formsValidationsWithRelations.push({
                id: form.id,
                code: form.code,
                variables: formValidation.sort((a, b) => a.position - b.position),
                metricsVariables: form.jsonField?.metricsVariables || [],
                isGenealVariable: form.jsonField?.isGenealVariable || false,
            });
        }
        return formsValidationsWithRelations;
    }
};
exports.FormsValidationsService = FormsValidationsService;
exports.FormsValidationsService = FormsValidationsService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(forms_validations_entity_1.FormsValidationsEntity)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        origin_flow_variables_service_1.OriginFlowVariablesService,
        configuration_service_1.ConfigurationService])
], FormsValidationsService);
//# sourceMappingURL=forms-validations.service.js.map