import { Repository } from 'typeorm';
import { TaskEntity } from '../entities/task.entity';
import { CreateTaskDto } from '../dto/create-task.dto';
import { UpdateTaskDto } from '../dto/update-task.dto';
import { UserEntity } from '../entities/user.entity';
export declare class TaskService {
    private readonly taskRepository;
    private readonly userRepository;
    constructor(taskRepository: Repository<TaskEntity>, userRepository: Repository<UserEntity>);
    create(createTaskDto: CreateTaskDto): Promise<TaskEntity>;
    validateTaskByOriginFlow(originFlow: any, useId: any): any;
    findAll(): Promise<TaskEntity[]>;
    findOne(id: string): Promise<TaskEntity>;
    getTaskByOriginFlow(originFlow: any, useId: any): Promise<TaskEntity>;
    finishTask(id: string): Promise<TaskEntity>;
    update(id: string, updateTaskDto: UpdateTaskDto): Promise<TaskEntity>;
    remove(id: string): Promise<void>;
    getTasksPaginatedByOriginFlow(originFlow: string, page: number, size: number): Promise<{
        tasks: any[];
        total: number;
    }>;
}
