"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TaskService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const task_entity_1 = require("../entities/task.entity");
const user_entity_1 = require("../entities/user.entity");
let TaskService = class TaskService {
    constructor(taskRepository, userRepository) {
        this.taskRepository = taskRepository;
        this.userRepository = userRepository;
    }
    async create(createTaskDto) {
        const user = await this.userRepository.findOne({ where: { id: createTaskDto.userId } });
        if (!user) {
            throw new common_1.NotFoundException(`User with ID ${createTaskDto.userId} not found`);
        }
        const task = this.taskRepository.create({
            ...createTaskDto,
            user,
        });
        return this.taskRepository.save(task);
    }
    validateTaskByOriginFlow(originFlow, useId) {
        return this.taskRepository.find({ where: { originFlow: { id: originFlow }, user: { id: useId }, state: (0, typeorm_2.Not)('finished') } });
    }
    async findAll() {
        return this.taskRepository.find({ relations: ['user'] });
    }
    async findOne(id) {
        const task = await this.taskRepository.findOne({ where: { id }, relations: ['user'] });
        if (!task) {
            throw new common_1.NotFoundException(`Task with ID ${id} not found`);
        }
        return task;
    }
    async getTaskByOriginFlow(originFlow, useId) {
        return this.taskRepository.findOne({ where: { originFlow: { id: originFlow }, user: { id: useId }, state: (0, typeorm_2.Not)('finished') } });
    }
    async finishTask(id) {
        const task = await this.taskRepository.findOne({ where: { id } });
        if (!task) {
            throw new common_1.NotFoundException(`Task with ID ${id} not found`);
        }
        task.state = "finished";
        return this.taskRepository.save(task);
    }
    async update(id, updateTaskDto) {
        const task = await this.taskRepository.preload({
            id,
            ...updateTaskDto,
        });
        if (!task) {
            throw new common_1.NotFoundException(`Task with ID ${id} not found`);
        }
        if (updateTaskDto.userId) {
            const user = await this.userRepository.findOne({ where: { id: updateTaskDto.userId } });
            if (!user) {
                throw new common_1.NotFoundException(`User with ID ${updateTaskDto.userId} not found`);
            }
            task.user = user;
        }
        return this.taskRepository.save(task);
    }
    async remove(id) {
        const result = await this.taskRepository.delete(id);
        if (result.affected === 0) {
            throw new common_1.NotFoundException(`Task with ID ${id} not found`);
        }
    }
    async getTasksPaginatedByOriginFlow(originFlow, page, size) {
        const whereCondition = originFlow ? { originFlow: { id: originFlow } } : {};
        const [tasks, total] = await this.taskRepository.findAndCount({
            where: whereCondition,
            relations: ['user', 'originFlow'],
            skip: (page > 0 ? page - 1 : 0) * size,
            take: size,
        });
        const filterTask = tasks.map(task => {
            return { ...task, user: { email: task.user.email, name: task.user.fullName } };
        });
        return { tasks: filterTask, total };
    }
};
exports.TaskService = TaskService;
exports.TaskService = TaskService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(task_entity_1.TaskEntity)),
    __param(1, (0, typeorm_1.InjectRepository)(user_entity_1.UserEntity)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository])
], TaskService);
//# sourceMappingURL=tasks.service.js.map