import { Repository } from 'typeorm';
import { UserEntity } from '../entities/user.entity';
import { JwtService } from '@nestjs/jwt';
import { ConfigService } from '@nestjs/config';
import { ConfigurationService } from './configuration.service';
import { LocationsService } from 'src/projects/services/locations.service';
import { FormsValidationsService } from './forms-validations.service';
export declare class UserService {
    private readonly userRepository;
    private readonly configService;
    private readonly jwtService;
    private readonly configurationService;
    private readonly locationsService;
    private readonly formsValidationsService;
    constructor(userRepository: Repository<UserEntity>, configService: ConfigService, jwtService: JwtService, configurationService: ConfigurationService, locationsService: LocationsService, formsValidationsService: FormsValidationsService);
    addUser(user: UserEntity): Promise<UserEntity>;
    validateUser(token: string): Promise<any>;
    login(email: string, password: string): Promise<any>;
    loginFromMobile(email: string, password: string): Promise<any>;
    getAllUsers(): Promise<UserEntity[]>;
    getUsersByIds(ids: string[]): Promise<UserEntity[]>;
    getLastUpdatedAndNumberOfRecords(): Promise<any>;
}
