"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const user_entity_1 = require("../entities/user.entity");
const jwt_1 = require("@nestjs/jwt");
const bcrypt = require("bcrypt");
const config_1 = require("@nestjs/config");
const configuration_service_1 = require("./configuration.service");
const locations_service_1 = require("../../projects/services/locations.service");
const forms_validations_service_1 = require("./forms-validations.service");
let UserService = class UserService {
    constructor(userRepository, configService, jwtService, configurationService, locationsService, formsValidationsService) {
        this.userRepository = userRepository;
        this.configService = configService;
        this.jwtService = jwtService;
        this.configurationService = configurationService;
        this.locationsService = locationsService;
        this.formsValidationsService = formsValidationsService;
    }
    async addUser(user) {
        user.password = await bcrypt.hash(user.password, 10);
        return this.userRepository.save(user);
    }
    async validateUser(token) {
        const decoded = this.jwtService.verify(token);
        const user = await this.userRepository.findOne({ where: { email: decoded.user.email } });
        if (user) {
            const access_token = this.jwtService.sign({ user });
            const modulesConfig = (await this.configurationService.findByCode('MODULES_CONFIG'))?.jsonConfig;
            return { ...user, status: common_1.HttpStatus.OK, token: access_token, config: { modulesConfig } };
        }
        return new common_1.HttpException('Invalid email or password', common_1.HttpStatus.BAD_REQUEST);
    }
    async login(email, password) {
        const user = await this.userRepository.findOne({ where: { email } });
        if (user) {
            const access_token = this.jwtService.sign({ user });
            const isValidPassword = await bcrypt.compare(password, user.password);
            if (isValidPassword) {
                const modulesConfig = (await this.configurationService.findByCode('MODULES_CONFIG'))?.jsonConfig;
                return { ...user, status: common_1.HttpStatus.OK, token: access_token, config: { modulesConfig } };
            }
        }
        return new common_1.HttpException('Invalid email or password', common_1.HttpStatus.BAD_REQUEST);
    }
    async loginFromMobile(email, password) {
        const user = await this.userRepository.findOne({ where: { email } });
        if (user) {
            const access_token = this.jwtService.sign({ user });
            const isValidPassword = await bcrypt.compare(password, user.password);
            if (isValidPassword) {
                const locationConfig = await this.locationsService.getLastUpdatedAndNumberOfRecords();
                const userConfig = await this.getLastUpdatedAndNumberOfRecords();
                const formValidation = await this.formsValidationsService.getLastUpdatedAndNumberOfRecords();
                const modulesConfig = {
                    usersLastUpdated: userConfig.lastUpdated,
                    usersAmountRecords: userConfig.numberOfRecords,
                    locationsLastUpdated: locationConfig.lastUpdated,
                    locationsAmountRecords: locationConfig.numberOfRecords,
                    formsLastUpdated: formValidation.lastUpdated,
                    formsAmountRecords: formValidation.numberOfRecords,
                };
                return { ...user, status: common_1.HttpStatus.OK, token: access_token, modulesConfig };
            }
        }
        return new common_1.HttpException('Invalid email or password', common_1.HttpStatus.BAD_REQUEST);
    }
    async getAllUsers() {
        return this.userRepository.find();
    }
    async getUsersByIds(ids) {
        return this.userRepository.find({ where: { id: (0, typeorm_2.In)(ids) }, relations: ['departments'] });
    }
    async getLastUpdatedAndNumberOfRecords() {
        const lastUpdated = await this.userRepository
            .createQueryBuilder('user')
            .select('MAX(user.updatedAt)', 'lastUpdated')
            .getRawOne();
        const numberOfRecords = await this.userRepository
            .createQueryBuilder('user')
            .getCount();
        return {
            lastUpdated: lastUpdated?.lastUpdated || null,
            numberOfRecords,
        };
    }
};
exports.UserService = UserService;
exports.UserService = UserService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(user_entity_1.UserEntity)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        config_1.ConfigService,
        jwt_1.JwtService,
        configuration_service_1.ConfigurationService,
        locations_service_1.LocationsService,
        forms_validations_service_1.FormsValidationsService])
], UserService);
//# sourceMappingURL=users.service.js.map