import { HttpException } from '@nestjs/common';
import { UserService } from './services/users.service';
import { UserEntity } from './entities/user.entity';
import { TaskService } from './services/tasks.service';
import { CreateTaskDto } from './dto/create-task.dto';
import { ConfigurationService } from './services/configuration.service';
import { FormsValidationsService } from './services/forms-validations.service';
export declare class SharedController {
    private readonly userService;
    private readonly taskService;
    private readonly configurationService;
    private readonly formsValidationsService;
    constructor(userService: UserService, taskService: TaskService, configurationService: ConfigurationService, formsValidationsService: FormsValidationsService);
    addUser(user: UserEntity): Promise<UserEntity>;
    getAllUsers(): Promise<any[]>;
    loginWithToken(token: string): Promise<void>;
    login(body: any): Promise<UserEntity | HttpException>;
    loginFromMobile(body: any): Promise<UserEntity | HttpException>;
    getTasksPaginatedByOriginFlow(originFlow: string, page: number, size: number): Promise<any>;
    finishTask(body: any): Promise<any>;
    createTask(body: CreateTaskDto, req: any): Promise<any>;
    validateTaskByOriginFlow(req: any, originFlow: string): Promise<any>;
    getListForPlanningTask(): Promise<any>;
    geOriginFlowByUploadModule(uploadModule: string): Promise<any>;
    getFormValidations(formCode: string, fromModuleVersion: string): Promise<any>;
    getGroupAssignedConfig(): Promise<any>;
    getAllFormsValidationsForMobile(): Promise<any>;
}
