"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SharedController = void 0;
const common_1 = require("@nestjs/common");
const users_service_1 = require("./services/users.service");
const user_entity_1 = require("./entities/user.entity");
const jwt_auth_guard_1 = require("./auth/jwt-auth.guard");
const tasks_service_1 = require("./services/tasks.service");
const create_task_dto_1 = require("./dto/create-task.dto");
const configuration_service_1 = require("./services/configuration.service");
const forms_validations_service_1 = require("./services/forms-validations.service");
let SharedController = class SharedController {
    constructor(userService, taskService, configurationService, formsValidationsService) {
        this.userService = userService;
        this.taskService = taskService;
        this.configurationService = configurationService;
        this.formsValidationsService = formsValidationsService;
    }
    async addUser(user) {
        return this.userService.addUser(user);
    }
    async getAllUsers() {
        const users = await this.userService.getAllUsers();
        const userList = users.map(user => {
            return {
                id: user.id,
                email: user.email,
                name: user.fullName,
                role: user.roles
            };
        });
        return userList;
    }
    async loginWithToken(token) {
        return this.userService.validateUser(token);
    }
    async login(body) {
        return this.userService.login(body.email, body.password);
    }
    async loginFromMobile(body) {
        return this.userService.loginFromMobile(body.email, body.password);
    }
    async getTasksPaginatedByOriginFlow(originFlow, page, size) {
        return this.taskService.getTasksPaginatedByOriginFlow(originFlow, page, size);
    }
    async finishTask(body) {
        return this.taskService.finishTask(body.taskId);
    }
    async createTask(body, req) {
        const userId = req.user.userId;
        const existTask = await this.taskService.validateTaskByOriginFlow(body.originFlow, userId);
        if (!existTask || existTask.length === 0) {
            return this.taskService.create({ ...body, userId });
        }
        else {
            return existTask[0];
        }
    }
    async validateTaskByOriginFlow(req, originFlow) {
        const userId = req.user.userId;
        return this.taskService.validateTaskByOriginFlow(originFlow, userId);
    }
    async getListForPlanningTask() {
        const configuration = await this.configurationService.findByCode('LIST_FOR_PLANNING_TASK');
        return configuration?.jsonConfig;
    }
    async geOriginFlowByUploadModule(uploadModule) {
        return this.configurationService.getOriginFlowByUploadModule(uploadModule);
    }
    async getFormValidations(formCode, fromModuleVersion) {
        return this.formsValidationsService.getFormsValidations(formCode, fromModuleVersion);
    }
    async getGroupAssignedConfig() {
        const configuration = await this.configurationService.findByCode('GROUP_ASSIGNED');
        return configuration?.jsonConfig;
    }
    async getAllFormsValidationsForMobile() {
        return this.formsValidationsService.getAllFormsValidationsForMobile();
    }
};
exports.SharedController = SharedController;
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Post)('addUser'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [user_entity_1.UserEntity]),
    __metadata("design:returntype", Promise)
], SharedController.prototype, "addUser", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Get)('listOfUsers'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], SharedController.prototype, "getAllUsers", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Get)('login-with-token'),
    __param(0, (0, common_1.Headers)('Authorization')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], SharedController.prototype, "loginWithToken", null);
__decorate([
    (0, common_1.Post)('login'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], SharedController.prototype, "login", null);
__decorate([
    (0, common_1.Post)('loginFromMobile'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], SharedController.prototype, "loginFromMobile", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Get)('getTasksPaginatedByOriginFlow'),
    __param(0, (0, common_1.Headers)('originFlow')),
    __param(1, (0, common_1.Headers)('page')),
    __param(2, (0, common_1.Headers)('size')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number, Number]),
    __metadata("design:returntype", Promise)
], SharedController.prototype, "getTasksPaginatedByOriginFlow", null);
__decorate([
    (0, common_1.Post)('finish-task'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], SharedController.prototype, "finishTask", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Post)('create-task'),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Request)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_task_dto_1.CreateTaskDto, Object]),
    __metadata("design:returntype", Promise)
], SharedController.prototype, "createTask", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Get)('validate-task-by-origin-flow'),
    __param(0, (0, common_1.Request)()),
    __param(1, (0, common_1.Headers)('originFlow')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, String]),
    __metadata("design:returntype", Promise)
], SharedController.prototype, "validateTaskByOriginFlow", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Get)('getListForPlanningTask'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], SharedController.prototype, "getListForPlanningTask", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Get)('getOriginFlowByUploadModule'),
    __param(0, (0, common_1.Headers)('uploadModule')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], SharedController.prototype, "geOriginFlowByUploadModule", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Get)('getFormValidations'),
    __param(0, (0, common_1.Headers)('formCode')),
    __param(1, (0, common_1.Headers)('fromModuleVersion')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String]),
    __metadata("design:returntype", Promise)
], SharedController.prototype, "getFormValidations", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Get)('getGroupAssignedConfig'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], SharedController.prototype, "getGroupAssignedConfig", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Get)('getAllFormsValidationsForMobile'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], SharedController.prototype, "getAllFormsValidationsForMobile", null);
exports.SharedController = SharedController = __decorate([
    (0, common_1.Controller)('shared'),
    __metadata("design:paramtypes", [users_service_1.UserService,
        tasks_service_1.TaskService,
        configuration_service_1.ConfigurationService,
        forms_validations_service_1.FormsValidationsService])
], SharedController);
//# sourceMappingURL=shared.controller.js.map